﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel;

namespace WinForm_And_Data.Data.DataEntity
{
    public class DataController_Entity
    {
        #region singleton

        private static DataController_Entity dataController;

        public static DataController_Entity Get()
        {
            if (dataController == null)
                dataController = new DataController_Entity();

            return dataController;
        }

        public static void Destroy()
        {
            dataController = new DataController_Entity();
        }

        private DataController_Entity()
        {
        }

        #endregion


        //Тестовые данные для демонстрации
        #region TestData
        public enum Enum_DataType
        {
            entity,
            list,
            array,
            wrapper,
            BindingSortList
        }

        public object this[Enum_DataType e]
        {
            get
            {
                Object res = null;
                List<Entity> lst = null;

                switch (e)
                {
                    case Enum_DataType.entity:
                        res = Entity.GetNewEntity();
                        break;

                    case Enum_DataType.list:
                        lst = new List<Entity>();

                        for (int i = 0; i < 4; i++)
                            lst.Add(Entity.GetNewEntity());

                        res = lst;
                        break;

                    case Enum_DataType.array:
                        res = ((List<Entity>)this[Enum_DataType.list]).ToArray();
                        break;
                    case Enum_DataType.wrapper:
                        res = new Wrapper_Class()
                        {
                            list = ((List<Entity>)this[Enum_DataType.list])
                        };

                        break;

                    case Enum_DataType.BindingSortList:
                        lst = (List<Entity>)this[Enum_DataType.list];
                        lst[lst.Count-2].Id = 123;
                        res = new MyBindingList<Entity>((List<Entity>)lst);

                        break;
                }


                return res;
            }

        }

        #endregion
    }
}
