﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Collections.Concurrent;

using Model.Entities.Files.FS_Entities;

namespace BLL
{

    /// <summary>
    /// Создание одноразовых ссылок на файл.
    /// Используется для педоставления доступа к файлу с других сервисов (Просмотр документов)
    /// 
    /// Текущая реализация может привести к утечке памяти (ссылка удаляется только после обращения к ней)
    /// </summary>
    public class LinkStorage
    {
        private static readonly ConcurrentDictionary<string, SFile> TmpLinkData 
            = new ConcurrentDictionary<string, SFile>();


        /// <summary>
        /// Сгенерировать одноразовуй ключ для доступа к файлу
        /// </summary>
        /// <param name="file"></param>
        /// <returns></returns>
        public string CreateTmpLink(SFile file) 
        {
            string key = $"{Guid.NewGuid()}{Guid.NewGuid()}";

            if (!TmpLinkData.TryAdd(key, file)) 
            {
                throw new Exception("Данный ключ уже присутсвует коллизия. (В данных условиях не возможно)");
            }

            return key;
        }


        /// <summary>
        /// Получить данные о файле по ключу
        /// </summary>
        /// <returns></returns>
        public SFile GetLinkByKey(string key)
        {
            if (TmpLinkData.TryRemove(key, out SFile data))
            {
                return data;
            }

            throw new Exception("Не удалось найти указанный ключ");
        }


    }
}
