﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Model.Entities.Files;

namespace Model.Entities.Base
{
    public class Repo_Exception<T>
        : Exception where T
        : BaseEntity
    {
        public BaseRepository<T> repository { private set; get; }
        public FS_Item elem { private set; get; }

        public Repo_Exception(BaseRepository<T> repository, string msg, Exception ex = null)
            : base(msg, ex)
        {
            this.repository = repository;
        }

        public Repo_Exception(BaseRepository<T> repository, FS_Item elem, string msg, Exception ex = null)
            : base(msg, ex)
        {
            this.repository = repository;
            this.elem = elem;
        }


        #region        

        public static Repo_Exception<T> Factory(BaseRepository<T> repository, FS_Item elem, Repo_Exceptions type)
        {
            return new Repo_Exception<T>(repository, elem, type.ToString());
        }
    }

    public enum Repo_Exceptions
    {
        Name_already_exists_in_parents,
        Name_is_null_or_empty,
        Parent_is_null,
        Elem_items_not_empty,
        Name_cant_change,
        File_not_found,
        Size_not_equils,
        FSRepo_TypeException
    }

    #endregion

    public static class Exception_Extension
    {
        public static string FullMessage(this Exception ex)
        {
            StringBuilder res = new StringBuilder(ex.Message);

            var e = ex.InnerException;
            while (e != null)
            {
                res.Append("|" + e.Message);
                e = e.InnerException;
            }

            return res.ToString();
        }
    }

}
