﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ExpressionOperatorProxy.Generic.MathOperatorProxy
{

    //Обертка над StaticOperatorProxy для удобства использования
    public struct OperatorProxy<T>
    {
        public T Value { set; get; }


        public OperatorProxy(T value)
        {
            this.Value = value;
        }


        public static OperatorProxy<T> operator +(OperatorProxy<T> c1, T c2)
        {
            return new OperatorProxy<T>(StaticOperatorProxy<T>.Add(c1.Value, c2));
        }
        public static OperatorProxy<T> operator +(OperatorProxy<T> c1, OperatorProxy<T> c2)
        {
            return new OperatorProxy<T>(StaticOperatorProxy<T>.Add(c1.Value, c2.Value));
        }

        public static OperatorProxy<T> operator -(OperatorProxy<T> c1, T c2)
        {
            return new OperatorProxy<T>(StaticOperatorProxy<T>.Subtract(c1.Value, c2));
        }
        public static OperatorProxy<T> operator -(OperatorProxy<T> c1, OperatorProxy<T> c2)
        {
            return new OperatorProxy<T>(StaticOperatorProxy<T>.Subtract(c1.Value, c2.Value));
        }

        public static OperatorProxy<T> operator *(OperatorProxy<T> c1, T c2)
        {
            return new OperatorProxy<T>(StaticOperatorProxy<T>.Multiply(c1.Value, c2));
        }
        public static OperatorProxy<T> operator *(OperatorProxy<T> c1, OperatorProxy<T> c2)
        {
            return new OperatorProxy<T>(StaticOperatorProxy<T>.Multiply(c1.Value, c2.Value));
        }

        public static OperatorProxy<T> operator /(OperatorProxy<T> c1, T c2)
        {
            return new OperatorProxy<T>(StaticOperatorProxy<T>.Divide(c1.Value, c2));
        }
        public static OperatorProxy<T> operator /(OperatorProxy<T> c1, OperatorProxy<T> c2)
        {
            return new OperatorProxy<T>(StaticOperatorProxy<T>.Divide(c1.Value, c2.Value));
        }


        public override string ToString()
        {
            return Value.ToString();
        }

        public override int GetHashCode()
        {
            return Value.GetHashCode();
        }

        public override bool Equals(object obj)
        {
            return Value.Equals(obj);
        }

    }
}
