﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Diagnostics;
using System.Drawing;

using Graph.Simple.Entities;
using Graph.Converter;
using yEd.XGML.IO;
using yEd.XGML.DocumentEntities.NodeEntitie;

namespace YED.Console.Test
{
    /// <summary>
    /// Тест 
    /// 1) Создает Graph.Simple.Entities.Graph
    /// 2) Конвертирует в yed xgml формат с помощью Graph.Converter
    /// 3) Записывает получившийся document в файл
    /// </summary>
    public class Test2_CreateGraph_and_ExportToYed
    {
        public void Test(bool OpenDst = false)
        {
            string TestFile_Dst = @"Documents\Document2_Created.xgml";

            //Создание графа
            Graph.Simple.Entities.Graph graph = new Graph.Simple.Entities.Graph();

            for (int i = 0; i < 3; i++)
                graph.AddNode();

            graph.AddEdge(graph.Nodes[1], graph.Nodes[0], 10);
            graph.AddEdge(graph.Nodes[2], graph.Nodes[0], 20);


            //Экспорт в XDGM Document
            var doc = new Converter().GraphToYed(graph);


            //Изменение на уровне XDGM Document
            var nodes = doc.Nodes;

            nodes[0].graphics.fill = Color.Red;
            nodes[1].graphics.x -= 100;
            nodes[2].graphics.x += 100;

            //Запись
            doc.SaveAs(TestFile_Dst);

            if (OpenDst)
                Process.Start(TestFile_Dst);
        }
    }
}
