﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;

using yEd.XGML.IO.Write.Tools;
using yEd.XGML.DocumentEntities.NodeEntitie;

namespace yEd.XGML.IO.Write
{
    internal class NodeWriter : IWriter<Node>
    {
        public XElement Write(Node elem)
        {
            var res = XElement_Tools.CreateSection("node");

            res.Add(XElement_Tools.CreateAttribute("id", "int", elem.id.ToString()));
            res.Add(XElement_Tools.CreateAttribute("label", "String", elem.label));
           
            
            res.Add(WriteGraphics(elem.graphics));
            res.Add(WriteLabelGraphics(elem));

            if (elem.gid.HasValue)            
                res.Add(XElement_Tools.CreateAttribute("gid", "int", elem.gid));            

            return res;
        }

        private XElement WriteGraphics(NodeGraphics node_graphics)
        {
            XElement graphics = XElement_Tools.CreateSection("graphics");

            graphics.Add(XElement_Tools.CreateAttribute("x", "double", node_graphics.x));
            graphics.Add(XElement_Tools.CreateAttribute("y", "double", node_graphics.y));
            graphics.Add(XElement_Tools.CreateAttribute("w", "double", node_graphics.w));
            graphics.Add(XElement_Tools.CreateAttribute("h", "double", node_graphics.h));
            graphics.Add(XElement_Tools.CreateAttribute("type", "String", node_graphics.type));
            graphics.Add(XElement_Tools.CreateAttribute("raisedBorder", "boolean", node_graphics.raisedBorder.ToString().ToLower()));
            graphics.Add(XElement_Tools.CreateAttribute("fill", "String", Color_Tools.ColorToHex(node_graphics.fill)));
            graphics.Add(XElement_Tools.CreateAttribute("outline", "String", Color_Tools.ColorToHex(node_graphics.outline)));

            return graphics;
        }
        private XElement WriteLabelGraphics(Node node)
        {
            XElement LabelGraphics = XElement_Tools.CreateSection("LabelGraphics");

            LabelGraphics.Add(XElement_Tools.CreateAttribute("text", "String", node.label));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("fontSize", "int", node.LabelGraphics.fontSize.ToString()));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("fontName", "String", node.LabelGraphics.fontName));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("anchor", "String", node.LabelGraphics.anchor));

            return LabelGraphics;
        }

    }
}
