﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using yEd.XGML.DocumentEntities;
using Graph.Simple.Entities;

using yEd.XGML.DocumentEntities.NodeEntitie;
using yEd.XGML.DocumentEntities.EdgeEntitie;


namespace Graph.Converter
{
    public class Converter
    {
        public Simple.Entities.Graph YedToGraph(Document document)
        {
            Simple.Entities.Graph res = new Simple.Entities.Graph();

            //yEd ID, Graph ID
            Dictionary<int, int> ID_mapper = new Dictionary<int, int>(document.Elements.Count());

            foreach (var elem in document.Elements.Values)
            {
                if (!elem.isGroup)
                {
                    var n_node = res.AddNode();
                    ID_mapper.Add(elem.id, n_node.ID);
                }
            }


            foreach (var elem in document.Edges)
            {
                if (!res.Nodes.ContainsKey(ID_mapper[elem.source]) || !res.Nodes.ContainsKey(ID_mapper[elem.target]))
                    continue;

                var NodeStart = res.Nodes[ID_mapper[elem.source]];
                var NodeEnd = res.Nodes[ID_mapper[elem.target]];
                float widht = 1;

                float.TryParse(elem.label, out widht);

                res.AddEdge(NodeStart, NodeEnd, widht);
            }


            return res;
        }

        public Document GraphToYed(Simple.Entities.Graph graph)
        {
            Document document = new Document();

            foreach (var elem in graph.Nodes.Values)
            {
                document.Elements.Add(elem.ID, new yEd.XGML.DocumentEntities.NodeEntitie.Node()
                {
                    id = elem.ID,
                    label = "Node " + elem.ID
                });
            }

            foreach (var elem in graph.Edges.Values)
            {
                document.Edges.Add(new yEd.XGML.DocumentEntities.EdgeEntitie.Edge()
                {
                    source = elem.Start.ID,
                    target = elem.End.ID,
                    label = elem.Weight.ToString()
                });
            }

            return document;
        }
    }
}
