
import { DependencyInfo } from '../../DI/BaseObject';

import { IWeatherApiClient } from '../../DAL.Contract/WebApi/IWeatherApiClient';
import { ApiQueryExecuter } from './ApiQueryExecuter';


export class WeatherApiClient extends IWeatherApiClient {

    constructor() {

        let dependecies = [
            new DependencyInfo('QueryExecuter', ApiQueryExecuter.InterfaceName)
        ];

        super(
            'WeatherApiClient',
            null,
            dependecies          
        );
    }

    WeatherForecasts() {
        let methodName = 'WeatherForecasts';
        let url = 'api/SampleData/WeatherForecasts';

        return this.QueryExecuter
            .Execute(
                url,
                null,
                this.ClassName,
                this.AbstractClassName,
                methodName
            );     
    }

}

