
import { ErrorEntity, ArgumentErrorEntity } from '../Entities/Error/ErrorEntity';

/**
 *   ,     DI
*/
export class DependencyInfo
{

/**
* @param {string} parameterName  
* @param {any} parameterValue  
 *@param {any} dependencyConstructorParameter ,    
*/
    constructor(
        fieldName,
        dependencyName,
        dependencyConstructorParameter = null
    ) 
    {
        this.FieldName = fieldName;
        this.DependencyName = dependencyName;
        this.DependencyConstructorParameter = dependencyConstructorParameter;
    }
}


/**
 *      
 *    .
*/
export class BaseObject {
    static AbstractionName = 'BaseObject';

    static ServiceLocator;
    static Init(serviceLocator) {

        if (serviceLocator === null
            || serviceLocator === undefined) {

            let ex = new ErrorEntity(ErrorEntity.Exception, 'serviceLocator is empty')
                .SetClassName(BaseObject.AbstractionName)
                .SetMethodName('static Init');

            console.error(ex);
            throw ex;
        }

        BaseObject.ServiceLocator = serviceLocator;
    }


    /**
     *  /   
     * :
     *  
     * ,     
     * 
     * 
    * @param {string} className   
    * @param {string} abstractClassName  ,      
    * @param {DependencyInfo[]} constructorParameters     
    */
    constructor(
        className,
        abstractClassName = null,
        objectDependencies = null
    ) {
        this.ClassName = className;
        this.AbstractClassName = abstractClassName !== null
            ? abstractClassName
            : BaseObject.AbstractionName;

        this._TestClassName(className, this.AbstractClassName);
        this._FillDependency(objectDependencies);
    }



    /**
     *   className
     * */
    _TestClassName(className, abstractClassName) {
        if (className === "") {

            throw new
                ArgumentErrorEntity('classname is empty')
                .SetAbstacrtClassName(abstractClassName)
                .SetClassName(className)
                .SetMethodName('TestClassName');

        }
    }

    /**
     *       constructorParameters
     * */
    _FillDependency(objectDependencies) {

        let th = this;

        if (objectDependencies === null) {
            return;
        }

        objectDependencies.forEach(function (elem, i, arr) {

            // 
            let dependencyObject =
                elem.DependencyConstructorParameter === null
                    ? BaseObject.ServiceLocator
                        .Get(elem.DependencyName)
                    : BaseObject.ServiceLocator
                        .Get(elem.DependencyName, elem.DependencyConstructorParameter);

            //,    
            if (dependencyObject === null
                || dependencyObject === undefined) {

                throw new
                    ErrorEntity(
                        ErrorEntity.Exception,
                        'Dependecy ' + elem.DependencyName + ' is empty'
                    )
                    .SetClassName(th.ClassName)
                    .SetAbstacrtClassName(th.abstractClassName)
                    .SetMethodName('_FillDependency');
            }

            // 
            th[elem.FieldName] = dependencyObject;
        }
        );
    }


    /**
     *  :  .
     *  :    
    * */
    ThrowNotImplementationError(methodName) {

        let error = new ErrorEntity(
            ErrorEntity.NotImplementationException,
            'Method ' + methodName + ' not implemented'
        )
            .SetAbstacrtClassName(this.AbstractClassName)
            .SetClassName(this.ClassName)
            .SetMethodName(methodName);

        throw error;
    }

}
