import { ErrorEntity } from '../Entities/Error/ErrorEntity';

import { ApiQueryExecuter } from '../DAL/WebApi/ApiQueryExecuter'
import { IWeatherApiClient } from '../DAL.Contract/WebApi/IWeatherApiClient'
import { WeatherApiClient } from '../DAL/WebApi/WeatherApiClient'
import { StubWeatherApiClient } from '../DAL/WebApi/StubWeatherApiClient'


class DependencyInfo {

    constructor(
        name,
        type,
        isSinglethon
    ) {

        this.Name = name;
        this.Type = type;
        this.IsSinglethon = isSinglethon;

    }

    Get() {
        if (!this.IsSinglethon) {
            return new this.Type();
        }
        else {
            if (this._Singlethon === undefined) {
                this._Singlethon = new this.Type();
            }

            return this._Singlethon; 
        }
    }

}

/**
 *   
 * */
class MySimpleDI {

    constructor() {
        this.BindingDictionary = {};
    }


    _Registry(name, type, isSinglethon) {

        if (name === null) {
            throw 'Name is empty';
        }

        let dependencyInfo = this.BindingDictionary[name];

        if (dependencyInfo !== null
            && dependencyInfo !== undefined) {
            throw 'Dependecy already exists: ' + name;
        }

        this.BindingDictionary[name] = new DependencyInfo(name, type, isSinglethon);
    }

    Registry(name, type) {

        this._Registry(name, type, false);
        
    }
    RegistrySinglethon(name, type) {

        this._Registry(name, type, true);

    }


    Get(name) {

        if (name === null) {
            throw 'Name is empty';
        }

        let dependencyInfo = this.BindingDictionary[name];

        if (dependencyInfo === null
            || dependencyInfo === undefined) {
            throw 'Dependecy not found: ' + name;
        }

        return dependencyInfo.Get();
    }

}


/**
 * ,  
 *  DI   MySimpleDI
 * */
export class DependecyModule2 {
    static ClassName = 'DependecyModule2';

    constructor() {
        this.Di = null;
    }

    /**
         
    */
    Registry() {

        if (this.Di !== null) {
            throw new ErrorEntity(ErrorEntity.ArgumentException, 'Dependecy already registered')
                .SetClassName(DependecyModule2.ClassName)
                .SetMethodName('Registry');
        }

        this.Di = new MySimpleDI();

        this.RegistryDAL();
    }



    RegistryDAL() {

        this.Di.RegistrySinglethon(
            ApiQueryExecuter.InterfaceName,
            ApiQueryExecuter
        );


        this.Di.RegistrySinglethon(
            IWeatherApiClient.InterfaceName,
            WeatherApiClient,
        );
    }


    /**
    *     
    *
    * @param {string} name  .
    */
    Get(name, param = null) {
        return this.Di.Get(name);
    }

}

