
import { ErrorEntity } from './ErrorEntity';

export class ApiClientErrorEntity extends ErrorEntity {
    static Type = 'ApiClientException';

    constructor(message) {

        super(ApiClientErrorEntity.Type, message, false);

        this.Url = undefined;

        this.RequestDate = undefined;
        this.ResponseDate = undefined;

        this.StatusText = undefined;
        this.StatusCide = undefined;

        this.RequestText = undefined;
        this.ResponseText = undefined;

        this.stack = new Error().stack;
    }


    SetUrl(url) {
        this.Url = url;
        return this;
    }

    SetRequestDate(requestDate) {
        this.RequestDate = requestDate;
        return this;
    }

    SetResponseDate(responseData) {
        this.ResponseDate = responseData;
        return this;
    }

    SetStatusText(statusText) {
        this.StatusText = statusText;
        return this;
    }

    SetStatusCode(statusCode) {
        this.StatusCide = statusCode;
        return this;
    }

    SetRequestText(requestText) {
        this.RequestText = requestText;
        return this;
    }
    SetResponseText(responseText) {
        this.ResponseText = responseText;
        return this;
    }

}


