import React, { Component } from 'react';

import { BaseObject } from '../Model/DI/BaseObject'


export class BaseComponent extends Component{

    constructor(
        props,
        className,
        abstractClassName = null,
        objectDependencies = null,        
    ) {
        super(props);

        let base = new BaseObject(
            className,
            abstractClassName,
            objectDependencies
        );

        this.ClassName = base.ClassName;
        this.AbstractClassName = base.AbstractClassName;

        if (objectDependencies !== null) {

            let th = this;

            //   BaseObject
            objectDependencies.forEach(
                function (elem, i, arr) {
                    th[elem.FieldName] = base[elem.FieldName];
                }
            );

        }
    }

}

