import React from 'react';

import { ErrorEntity } from '../../Model/Entities/Error/ErrorEntity';

import { BaseComponent } from '../BaseComponent';

export class ErrorBoundary extends BaseComponent {

    constructor(props) {
        super(props, ErrorBoundary.name);

        this.state = {
            errorData: null,
        }
    }

    shouldComponentUpdate(nextProps, nextState) {

        //      
        if (this.props !== nextProps) {
            this.setState(
                {
                    errorData: null
                }
            );
        }

        return true;
    }
   
    componentDidCatch(error) {

        let er;

        if (error.IsErrorEntity) {
            er = error;
        }
        else {
            er = new ErrorEntity(ErrorEntity.Exception, 'System Error')
                .SetClassName(this.ClassName)
                .SetAbstacrtClassName(this.AbstractClassName)
                .SetInnerError(error);
        }

        //        
        this.setState({ errorData: er });
    }

    render() {

        let preStyle =
        {
                whiteSpace: 'pre-wrap'
        };

        if (this.state.errorData !== null) {
            return (
                <div>
                    <pre style={preStyle}>
                        {this.state.errorData.ToJsonString()}
                    </pre>
                </div>                   
            );
        }

        return this.props.children;
    }
};
