import { DI } from 'di-xxl';

import { ErrorEntity } from '../Entities/Error/ErrorEntity';

import { ApiQueryExecuter } from '../DAL/WebApi/ApiQueryExecuter'
import { IWeatherApiClient } from '../DAL.Contract/WebApi/IWeatherApiClient'
import { WeatherApiClient } from '../DAL/WebApi/WeatherApiClient'
import { StubWeatherApiClient } from '../DAL/WebApi/StubWeatherApiClient'


/**
 * ,  
 *  DI   di-xxl
 * */
export class DependecyModule {
    static ClassName = 'DependecyModule';

    constructor() {
        this.Di = null;
    }

/**
     
*/
    Registry() {

        if (this.Di !== null)
        {
            throw new ErrorEntity(ErrorEntity.ArgumentException, 'Dependecy already registered')
                .SetClassName(DependecyModule.ClassName)
                .SetMethodName('Registry');
        }

        this.Di = new DI();
        this.BindingNames = [];

        this.RegistryDAL();
    }



    RegistryDAL() {

        this._Registry(
            {
                name: ApiQueryExecuter.InterfaceName,
                ref: ApiQueryExecuter
            }
        );


        this._Registry(
            {
                name: IWeatherApiClient.InterfaceName,
                ref: WeatherApiClient
            }
        );

        //this._Registry(
        //    {
        //        name: IWeatherApiClient.InterfaceName,
        //        ref: StubWeatherApiClient,
        //    }
        //);

    }


    _Registry(bindingInfo) {

        if (bindingInfo.name === null
            || bindingInfo.name === undefined
        ) {
            throw new ErrorEntity(ErrorEntity.ArgumentException, 'bindingInfo.name is empty')
                .SetClassName(DependecyModule.ClassName)
                .SetMethodName('_Registry');
        }

        //,      
        if (this.BindingNames.indexOf(bindingInfo.name) !== -1) {
            throw new ErrorEntity(ErrorEntity.ArgumentException, 'bindingInfo.name=' + bindingInfo.name + ' already use')
                .SetClassName(DependecyModule.ClassName)
                .SetMethodName('_Registry');
        }

        this.Di.set(bindingInfo);
        this.BindingNames.push(bindingInfo.name);        
    }

/**
*     
*
* @param {string} type  .
*/
    Get(type) {
        return this.Di.get(type);
    }

/**
 *        
 *
 * @param {string} type  .
 * @param {any} param  .
*/
    GetWithParam(type, param) {
        return this.Di.get(type, { params: param });
    }

}




