

export class ErrorEntity {

    //ExceptionTypeList
    static Exception = 'Exception';    
    static NotImplementationException = 'NotImplementationException';


    constructor(exceptionType, message, fileStack = true)
    {
        this.name = exceptionType;
        this.message = message;
        this.AbstacrtClassName = undefined;
        this.ClassName = undefined;
        this.MethodName = undefined;

        this.IsErrorEntity = true;

        if (fileStack) {
            this.stack = new Error().stack;
        }
    }  


    SetAbstacrtClassName(abstarctClassName) {
        this.AbstacrtClassName = abstarctClassName;
        return this;
    }

    SetClassName(className) {
        this.ClassName = className;
        return this;
    }

    SetMethodName(methodName) {
        this.MethodName = methodName;
        return this;
    }

    SetInnerError(innerError) {
        this.InnerError = innerError;
        return this;
    }


    ToJsonString()
    {
        return JSON.stringify(this, null, '  ');
    }

}

export class ArgumentErrorEntity extends ErrorEntity {
    static Type = 'ArgumentException';

    constructor(message) {
        super(ArgumentErrorEntity.Type, message);
    }

}


