﻿//Получить данные поселения по имени
function GetInfoAboutSettlement(URL, functionWhatNeedToDoWithInfo) {
    $.ajax({
        url: '/MapAPI/GetSettlement',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            URL: URL
        },

        success: function (data) {
            functionWhatNeedToDoWithInfo(data);
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//Получить массив всех точек поселений от сервера
function GetAllPoints(YearMin, YearMax) {
    $.ajax({
        url: '/MapAPI/GetAllPoints',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            YearMin: YearMin,
            YearMax: YearMax
        },
        success: function (data) {
            //  Нужно ли делать выборку
            //                     |
            FillDataArrays(data, true);            
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

function GetAllOfType(type) {
    return $.ajax({
        url: '/Map/GetAllOfType',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            type: type
        },
        success: function (data) {
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });

}

//Получить все имена поселений, подходящие по маске subName
function GetNames(subName, functionWhatNeedToDoWithInfo) {
    $.ajax({
        url: '/MapAPI/GetNames',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            subName: subName
        },

        success: function (data) {
            functionWhatNeedToDoWithInfo(data);
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//  Функция запроса дат
function GetDate(load = false) {
    $.ajax({
        url: '/MapAPI/GetYears',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        success: function (data) {
            
            MinYear = data.Item1;
            CurrentMinYear = data.Item2;
            CurrentMaxYear = MaxYear = new Date().getFullYear();

            document.getElementById('slider-label-min').innerHTML = '<b>' + MinYear + '</b>';
            document.getElementById('slider-label-max').innerHTML = '<b>' + MaxYear + '</b>';

            if (load === true) {
                SliderInit();
                GetAllPoints(CurrentMinYear, CurrentMaxYear);
            }
            //  Присвоить даты
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//  Функция получения файла экспорта
function ExportData(type) {

    //  Сериализация данных в строку
    var collectionString = '';
    Collections.Export.forEach(function (element) {
        collectionString += '|' + element.url;
    });
    collectionString += '|';

    console.log('/Map/ExportInfo?data=' + encodeURIComponent(collectionString) + '&type=' + type);
    document.getElementById('my_iframe').src = '/Map/ExportInfo?data=' + encodeURIComponent(collectionString) + '&type=' + type;   
}

function ImportForm(formData, type) {
    return $.ajax({
        url: '/Map/ImportForm',
        type: 'POST',
        // из-за этой строки была ошибка 500//contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        data: {
            formData: formData,
            type: type
        },
        success: function (data) {
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//Получить массив всех точек поселений от сервера
function DeleteSettlement(type, url) {
    return $.ajax({
        url: '/Map/DeleteSettlement',
        type: 'POST',
        //contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            type: type,
            url: url
        },
        success: function (data) {
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}



//function apiConnect(apiKey) {

//    function get(route) {
//        return fetch(`${route}?key=${apiKey}`);
//    }

//    function post(route, params) {
//        return
//        fetch(route,
//            {
//                method: 'POST',
//                body: JSON.stringify(params),
//                headers: {
//                    'Authorization': `Bearer ${apiKey}`
//                }
//            })
//    }

//    return { get, post }
//}
//const api = apiConnect('my-secret-key');
//// Использовать ключ доступа к API больше уже не нужно
//api.get('http://www.example.com/get-endpoint');
//api.post('http://www.example.com/post-endpoint', { name: 'Joe' });