
import { ApiClientErrorEntity } from '../../Entities/Error/ApiClientErrorEntity';

import { BaseObject } from '../../DI/BaseObject';

export class ApiQueryExecuter extends BaseObject {
    static InterfaceName = 'ApiQueryExecuter';


    constructor() {

        super('ApiQueryExecuter');

    }

    Execute(
        url,
        requestData,

        className,
        abstractClassName,
        methodName
    ) {

        let errorContext = new ApiClientErrorEntity('ApiQueryError');

        errorContext
            .SetClassName(className)
            .SetAbstacrtClassName(abstractClassName)
            .SetMethodName(methodName)

            .SetUrl(url)
            .SetRequestText(requestData)
            .SetRequestDate(new Date());


        return new Promise(
            (resolve, reject) => {

                fetch(url)
                    .then(
                        response => {
                            return this._ProcessingServerResponse(
                                response,
                                reject,
                                errorContext
                            );
                        }
                        ,
                        error => {
                            errorContext
                                .SetResponseDate(new Date())
                                .SetInnerError(error);

                            reject(errorContext);
                        }

                    )
                    .then(
                        data => resolve(data),
                        error => {
                            errorContext
                                .SetInnerError(error);

                            reject(errorContext);
                        }
                    );
            }
        )
    }


    _ProcessingServerResponse(
        response,
        reject,
        errorContext
    ) {
        errorContext
            .SetUrl(response.url)
            .SetResponseDate(new Date())
            .SetStatusText(response.StatusText)
            .SetStatusCode(response.Status);

        if (response.ok) {
            // json
            return response
                .json();
        }
        else {
            //   
            return response
                .text()
                .then(
                    (responseText) => {

                        errorContext
                            .SetResponseText(responseText);

                        reject(errorContext);
                    }
                    ,
                    (error) => {
                        errorContext
                            .SetResponseText('Error response.text()')
                            .SetInnerError(error);

                        reject(errorContext);
                    }
                );
        }
    }


}

