import React from 'react';

import { DependencyInfo } from '../../Model/DI/BaseObject';
import { BasePage } from './BasePage';

import { ErrorEntity } from '../../Model/Entities/Error/ErrorEntity'

import { IWeatherApiClient } from '../../Model/DAL.Contract/WebApi/IWeatherApiClient'


export class FetchDataPage extends BasePage {

    constructor(props) {

        let dependencies = [
            new DependencyInfo('WeatherApiClient', IWeatherApiClient.InterfaceName)
        ];

        super(props, FetchDataPage.name, null, dependencies);


        this.state =
        {
            forecasts: [],
            loading: true,

            errorData: null
        };

        this.Error = this.Error.bind(this);
        this.onClickUpdate = this.onClickUpdate.bind(this);        
    }

    componentDidMount() {
        this.onClickUpdate();
    }

    Error(error) {

        let er;

        er = new ErrorEntity(ErrorEntity.Exception, 'Error')
            .SetClassName(this.ClassName)
            .SetAbstacrtClassName(this.AbstractClassName)
            .SetMethodName('WeatherForecasts')
            .SetInnerError(error);

        console.error(er.ToJsonString());

        this.setState(
            (prevState, props) => {
                let state =
                {
                    errorData: er
                };

                return state;
            }
        );
    }

    onClickUpdate() {

        this.setState(
            {
                forecasts: [],
                loading: true,
                errorData: null
            }
        );

        this.WeatherApiClient.WeatherForecasts()
            .then(
                data => {
                    this.setState(
                        {
                            forecasts: data,
                            loading: false
                        }
                    );
                },
                this.Error
            );
    }


    renderRow(forecast) {
        return (
            <tr key={forecast.dateFormatted}>
                <td>{forecast.dateFormatted}</td>
                <td>{forecast.temperatureC}</td>
                <td>{forecast.temperatureF}</td>
                <td>{forecast.summary}</td>
            </tr>
        );
    }

    renderForecastsTable(forecasts) {
        return (
            <table className='table table-striped'>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Temp. (C)</th>
                        <th>Temp. (F)</th>
                        <th>Summary</th>
                    </tr>
                </thead>
                <tbody>
                    {forecasts.map(forecast =>
                        this.renderRow(forecast)
                    )}
                </tbody>
            </table>
        );
    }

    render() {

        if (this.state.errorData === null) {
            let contents =
                this.state.loading
                    ? <p><em>Loading...</em></p>
                    : this.renderForecastsTable(this.state.forecasts);

            return (
                <div>
                    <h1>Weather forecast</h1>
                    <p>This component demonstrates fetching data from the server.</p>
                    <p>{new Date().toISOString()}</p>
                    <p>
                        <button onClick={this.onClickUpdate}>UPDATE</button>
                    </p>
                    {contents}
                </div>
            );
        }
        else {
            let preStyle =
            {
                whiteSpace: 'pre-wrap'
            };

            return (

                <pre style={preStyle}>
                    {this.state.errorData.ToJsonString()}
                </pre>

            );
        }
    }
}
