import React from 'react';
import { Container } from 'reactstrap';

import { BaseComponent } from '../BaseComponent';

import { ErrorBoundary } from '../Components/ErrorBoundary';
import { NavMenu } from '../Components/NavMenu';

export class Layout extends BaseComponent {

    constructor(props) {
        super(props, Layout.name);
    }

    render() {
        return (
            <div>
                <NavMenu />
                <Container>
                    <ErrorBoundary errorMessage="Application has crashed">
                        {this.props.children}
                    </ErrorBoundary>
                </Container>
            </div>
        );
    }
}
