﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.BaseAndInterface;
using Tools;


namespace ModelData.BusinessModel.ExtraEntities
{
    /// \addtogroup Entities
    /// @{

    /// \class  Founder
    ///
    /// \brief  Отражает сущность основателя поселения Помимо наследуемых свойств, описывает
    ///         дополнительную информацию об основателе.
    ///
    /// \author Denis
    /// \date   30.03.2019

    public class Founder : BaseOntologyEntity
    {
        /// \property   public string Name
        ///
        /// \brief  Имя основателя, если это некоторая историческая личность.
        /// Установлен атрибут IndexAttrib со значением 2
        /// \returns    The name.

        [IndexAttrib(2)] public string Name { set; get; }



        /// \property   public string FounderRegion
        ///
        /// \brief  Наименование региона, который является родиной народа- или личности-основателя.
        /// Установлен атрибут IndexAttrib со значением 3
        /// \returns    The founder region.

        [IndexAttrib(3)] public string FounderRegion { set; get; }



        /// \property   public string Nationality
        ///
        /// \brief  Национальность народа- или личности-основателя.
        /// Установлен атрибут IndexAttrib со значением 4
        /// \returns    The nationality.

        [IndexAttrib(4)] public string Nationality { set; get; }



        /// \fn public override Dictionary<string, string> Serialize()
        ///
        /// \brief  Метод записи данных о сущности в Dictionary.
        ///
        /// \author Denis
        /// \date   30.03.2019
        ///
        /// \returns    A Dictionary&lt;string,string&gt;

        public override Dictionary<string, string> Serialize()
        {
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Название"] = this.Title ?? "",
                ["Имя"] = this.Name ?? "",
                ["Регион основателя"] = this.FounderRegion ?? "",
                ["Национальность"] = this.Nationality ?? ""
            };
        }
    }


    /// @}
}
