﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ComponentModel;

namespace ModelData.BusinessModel.Tools
{
    /// \addtogroup Entities
    /// @{

    /// \class  Coordinate
    ///
    /// \brief  Сущность географических координат
    ///
    /// \author Denis
    /// \date   31.03.2019

    public class Coordinate
    {
        /// \property   public double Lat
        ///
        /// \brief  Географическая широта
        ///
        /// \returns    The lat.

        [DisplayName("Широта")] public double Lat { set; get; }



        /// \property   public double Long
        ///
        /// \brief  Географическая долгота
        ///
        /// \returns    The long.

        [DisplayName("Долгота")] public double Long { set; get; }



        /// \fn public Coordinate()
        ///
        /// \brief  Стандартный конструктор
        /// Значения заполняются 0.
        /// \author Denis
        /// \date   31.03.2019

        public Coordinate()
        {
            Lat = 0;
            Long = 0;
        }



        /// \fn public Coordinate(VDS.RDF.INode long_, VDS.RDF.INode lat_)
        ///
        /// \brief  Конструктор на основе полученного из онтологии значения
        /// В качестве параметров передаются два "узла", которые являются результатом запроса из онтологии
        /// \warning Мои запросы ! требуют наличия координат, поэтому передаваемые значения никогда не будут null. Поэтому данная проверка не используется.
        /// \warning Нет проверки на правильность полученного значения, т.к. на данный момент онтология заполнялась вручную и все данные были верные.
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \param  long_   Результат запроса из онтологии "долгота".
        /// \param  lat_    Результат запроса из онтологии "широта".

        public Coordinate(VDS.RDF.INode long_, VDS.RDF.INode lat_)
        {
            this.Lat = double.Parse(long_.ToString().Split('^')[0].Replace('.', ','));
            this.Long = double.Parse(lat_.ToString().Split('^')[0].Replace('.', ','));
        }



        /// \fn public Coordinate(double x, double y)
        ///
        /// \brief  Конструктор на основе double значения
        ///
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \param  x   Координата широты.
        /// \param  y   Координата долготы.

        public Coordinate(double x, double y)
        {
            this.Lat = x;
            this.Long = y;
        }



        /// \fn public Coordinate(Coordinate origin)
        ///
        /// \brief  Конструктор копирования
        ///
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \param  origin  The origin.

        public Coordinate(Coordinate origin)
        {
            Lat = origin.Lat;
            Long = origin.Long;
        }

        /// \fn public override string ToString()
        ///
        /// \brief  Возвращает строку, представляющую текущий объект.
        /// Будучи базовой сущностью (не унаследованной от BaseOntologyEntity) требует преобразования в строку.
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \returns    Строка, представляющая текущий объект.

        public override string ToString()
        {
            return Lat + " " + Long;
        }


    }
    /// @}
}