﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools;


namespace ModelData.BusinessModel.MainEntities
{
    /// \addtogroup Entities
    /// @{

    /// \class  MapPoint
    ///
    /// \brief  Описывает точку на карте
    /// Класс описывает точку на карте и включает лишь необходимые для этого сведения, том числе и фильтруемую информацию.
    /// \author Denis
    /// \date   31.03.2019

    public class MapPoint : BaseAndInterface.BaseOntologyEntity
    {
        /// \property   public string Position
        ///
        /// \brief  Строковое представление координат
        /// Установлен атрибут IndexAttrib со значением 2
        /// \returns    The position.

        [IndexAttrib(2)] public string Position { set; get; }



        /// \property   public string Population
        ///
        /// \brief  Строковое значение количества населения
        /// Значение обязательно >= 0 - это гарантируется SPARQL запросом.
        /// В качестве значения выбирается наибольшее среди всех измененных поселений за выбранный промежуток.
        /// Установлен атрибут IndexAttrib со значением 3.
        /// \returns    The population.

        [IndexAttrib(3)] public string Population { set; get; }



        /// \property   public List<string> Type
        ///
        /// \brief  Список типов, к которым относится поселение
        /// Заполняется из всех измененных поселений за выбранный промежуток.
        /// Количество от 0 и больше.
        /// Установлен атрибут IndexAttrib со значением 4.
        /// \returns    The type.

        [IndexAttrib(4)] public List<string> Type { set; get; }

        /// \property   public List<string> Region
        ///
        /// \brief  Список регионов, в составе которых находится поселение
        /// Заполняется из всех измененных поселений за выбранный промежуток.
        /// Количество от 0 и больше.
        /// Установлен атрибут IndexAttrib со значением 5.
        /// \returns    The region.

        [IndexAttrib(5)] public List<string> Region { set; get; }


        /// \fn public MapPoint()
        ///
        /// \brief  Конструктор
        /// Создает экземпляры двух используемых списков
        /// \author Denis
        /// \date   31.03.2019

        public MapPoint()
        {
            Type = new List<string>();
            Region = new List<string>();
        }



        /// \fn public override Dictionary<string, string> Serialize()
        ///
        /// \brief  Метод записи данных о сущности в Dictionary.
        ///
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \returns    A Dictionary&lt;string,string&gt;

        public override Dictionary<string, string> Serialize()
        {
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Название"] = this.Title ?? "",
                ["Координаты"] = this.Position ?? "",
                ["Количество населения"] = this.Population,
                ["Тип поселения"] = Concat(this.Type),
                ["В составе региона"] = Concat(this.Region)
            };
        }

    }
    /// @}
}
