﻿//Получить данные поселения по имени
function GetInfoAboutSettlement(URL, functionWhatNeedToDoWithInfo) {
    $.ajax({
        url: '/MapAPI/GetSettlement',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            URL: URL
        },

        success: function (data) {
            functionWhatNeedToDoWithInfo(data);
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//Получить массив всех точек поселений от сервера
function GetAllPoints(YearMin, YearMax) {
    $.ajax({
        url: '/MapAPI/GetAllPoints',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            YearMin: YearMin,
            YearMax: YearMax
        },
        success: function (data) {
            //  Заполнить массивы из полученного результата
            FillDataArrays(data);
            //  Выбрать, какие именно данные нужно отобразить
            //  Затем: 
            //  Загрузить получившийся массив в коллекцию
            //                     |
            //                     |
            //                     | Выгрузить коллекцию на карту
            //                     |     |
            //                     |     |
            SelectDataFromArrays(true, true);
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//Получить все имена поселений, подходящие по маске subName
function GetNames(subName, functionWhatNeedToDoWithInfo) {
    $.ajax({
        url: '/MapAPI/GetNames',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            subName: subName
        },

        success: function (data) {
            functionWhatNeedToDoWithInfo(data);
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//  Функция запроса дат
function GetDate() {
    MinYear = 1590;
    CurrentMinYear = 2016;
    CurrentMaxYear = MaxYear = new Date().getFullYear();
    return;
    $.ajax({
        url: '/MapAPI/GetDate',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        success: function (data) {
            //  Присвоить даты
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}