﻿//  Функция обработчик движения слайдера
function SliderOnFinishMoving(data) {    
    CurrentMinYear = data.from;
    CurrentMaxYear = data.to;
    console.log(CurrentMinYear + " " + CurrentMaxYear);
}

//  Заполнение массивов из исходного (response.data)
//  В соответствии с параметрами поселения
function FillDataArrays(fromData) {
    Collections.All = new Array();
    Collections.Religion_1 = new Array();
    Collections.Religion_2 = new Array();
    Collections.Religion_3 = new Array();
    Collections.Religion_4 = new Array();
    Collections.Zoom_8 = new Array();
    Collections.Zoom_9 = new Array();
    Collections.Zoom_10 = new Array();
    Collections.Zoom_11 = new Array();
    Collections.Zoom_12 = new Array();
    Collections.Zoom_13 = new Array();
    Collections.Zoom_14 = new Array();
    Collections.Zoom_15 = new Array();
    Collections.Zoom_16 = new Array();
    Collections.Zoom_17 = new Array();
    Collections.Zoom_18 = new Array();
    Collections.Zoom_19 = new Array();
    Collections.Names = new Array();

    fromData.forEach(function (element)
    {
        Collections.Names.push(element.Name);   //  Массив всех имён поселений для автодополнения
        //Collections.All.push(element); //   В массив All идут все данные
        var pop = Number.parseInt(element.Population);  //  Получить числовое представления для сравнения с ключом константы
        //  Для каждой константы (пара ключ-значение, где 
        //                                                ключ = минимальное количество населения для попадания в массив
        //                                                значение = имя массива, в который нужно добавить поселение
        //                        )
        //  Выполнить сравнение количества населения и, если удовлетворяет условию, внести поселение в массив
        for (var key in ConstPopulation)
        {
            var value = ConstPopulation[key];
            if (pop > key)
                Collections[value].push(element);
        }          
    });
    AutoCompleteInit(Collections.Names);
}

function OnFindNameUsing(name)
{
    console.log(name);
}


//  Согласно текущим установленным фильтрам собрать нужный массив данных
function SelectDataFromArrays(isNeedLoadCollection = false, isNeedPlaceCollection = false) {
    var ResultDataArray = new Array();

    switch (CurrentZoom) {
        case 8: { ResultDataArray = Collections.Zoom_8; break; }
        case 9: { ResultDataArray = Collections.Zoom_9; break; }
        case 10: { ResultDataArray = Collections.Zoom_10; break; }
        case 11: { ResultDataArray = Collections.Zoom_11; break; }
        case 12: { ResultDataArray = Collections.Zoom_12; break; }
        case 13: { ResultDataArray = Collections.Zoom_13; break; }
        case 14: { ResultDataArray = Collections.Zoom_14; break; }
        case 15: { ResultDataArray = Collections.Zoom_15; break; }
        case 16: { ResultDataArray = Collections.Zoom_16; break; }
        case 17: { ResultDataArray = Collections.Zoom_17; break; }
        case 18: { ResultDataArray = Collections.Zoom_18; break; }
        case 19: { ResultDataArray = Collections.Zoom_19; break; }
        default: ResultDataArray = new Array()/*Collections.All*/;
    }   




    if (isNeedLoadCollection)
        LoadCollection(ResultDataArray, isNeedPlaceCollection);
    return ResultDataArray;
}

//  Функция заполнения Яндекс-коллекций Яндекс-объектами из JSON массива
function LoadCollection(fromData, bool = false)
{    
    //  Очистка коллекции от старых элементов. Параметры остаются прежними
    CollectionVisible.removeAll(); 
    fromData.forEach(function (element)
    {
        CollectionVisible.add(CreateYandexPlacemark(element)); //  Добавление
    });

    if (bool)
        PlaceFromCollection();
}

//  Функция создания Яндекс-объекта из одного элемента JSON массива
function CreateYandexPlacemark(fromElement) {
    var placemark = new ymaps.Placemark([fromElement.Position.X, fromElement.Position.Y],
        {
            iconContent: fromElement.Name,   //  Содержимое названия
            hintContent: [fromElement.Position.X, fromElement.Position.Y]//  Содержимое подписи при наведении
        }
    );

    //Добавить свойство - Имя поселения
    placemark.options.set('Name', fromElement.Name);
    placemark.options.set('URL', fromElement.URL);

    //  Переопределяем стадартный обработчик нажатия
    placemark.events.add('click', function (e) {
        e.preventDefault(); //  Запрещаем стандартный обработчик

        var targetName = e.get('target').options.get('Name');
        var targetURL = e.get('target').options.get('URL');

        //  Вызов запроса на получение данных о поселении
        GetInfoAboutSettlement(targetURL, PrintInfoAboutSettlement);

        //  Показать боковую панель
        if ($('#sidebar, #content').hasClass('active')) {
            //  Панель скрыта. Должна выехать
            $('#sidebar, #content').removeClass('active');
            $('.collapse.in').toggleClass('in');
            $('a[aria-expanded=true]').attr('aria-expanded', 'false');
        }
        else
            //  Панель есть. Выбор, нужно ли её скрывать
            if (targetName == document.getElementById('sidebar-header').getElementsByTagName('*')[0].innerHTML) {
                $('#sidebar, #content').addClass('active');
                $('.collapse.in').toggleClass('in');
                $('a[aria-expanded=true]').attr('aria-expanded', 'false');
            }


    });
    return placemark;
}