﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using ModelData.BusinessModel.RDF;

namespace ModelData.BusinessModel
{
    public class BusinessDataManager
    {
        #region singl

        private static BusinessDataManager dataManager;
        public static BusinessDataManager Get()
        {
            if (dataManager == null)
                dataManager = new BusinessDataManager();

            return dataManager;
        }
        public static void Destroy()
        {
            dataManager = null;
        }

        private BusinessDataManager()
        {
            Init();
        }

        #endregion

        #region Data

        private List<Settlement> lst_settlements;
        private bool needUpdate;

        #endregion

        #region Private Methods

        private void Init()
        {
            lst_settlements = new List<Settlement>();
            needUpdate = true;
        }

        private void LoadAllSettlements(string YearMin, string YearMax)
        {
            var lst_query = RDFQuery.GetData(RDFQuery.QueryType.AllSettlements , new string[] { YearMin, YearMax });
            Settlement settlement;

            /*
            0-9 : 151
            10-49 : 206
            50-99 : 136
            100-299 : 283
            300-999 : 409
            1000-4999 : 129
            5000-9999 : 18
            10000-29999 : 9
            30000-99999 : 7
            100000-999999 : 3
             */

            //Dictionary<string, int> stat = new Dictionary<string, int>
            //{
            //    ["0-9"] = 0,
            //    ["10-49"] = 0,
            //    ["50-99"] = 0,
            //    ["100-299"] = 0,
            //    ["300-999"] = 0,
            //    ["1000-4999"] = 0,
            //    ["5000-9999"] = 0,
            //    ["10000-29999"] = 0,
            //    ["30000-99999"] = 0,
            //    ["100000-999999"] = 0
            //};
            //System.IO.StreamWriter wr = new System.IO.StreamWriter("D:\\out.txt");
            foreach (var elem in lst_query)
            {
                int pop = int.Parse(elem["population"].ToString().Split('^')[0]);
                settlement = new Settlement(elem["settlement"].ToString(), elem["name"].ToString(), new Position(elem["long"], elem["lat"]))
                {
                    Population = elem["population"] != null ? elem["population"].ToString() : "0"
                };
                lst_settlements.Add(settlement);

                //if (pop > -1 && pop < 10)
                //    stat["0-9"]++;
                //else if (pop > 9 && pop < 50)
                //    stat["10-49"]++;
                //else if (pop > 49 && pop < 100)
                //    stat["50-99"]++;
                //else if (pop > 99 && pop < 300)
                //    stat["100-299"]++;
                //else if (pop > 299 && pop < 1000)
                //    stat["300-999"]++;
                //else if (pop > 999 && pop < 5000)
                //    stat["1000-4999"]++;
                //else if (pop > 4999 && pop < 10000)
                //    stat["5000-9999"]++;
                //else if (pop > 9999 && pop < 30000)
                //    stat["10000-29999"]++;
                //else if (pop > 29999 && pop < 100000)
                //    stat["30000-99999"]++;
                //else if (pop > 99999 && pop < 1000000)
                //    stat["100000-999999"]++;
            }

            //foreach (var item in stat)
            //    wr.WriteLine(item.Key + " : " + item.Value);
            //wr.Close();
        }

        static int u = 0;
        private void LoadInfoAboutSettlement(string URL)
        {
            System.IO.StreamWriter wr = new System.IO.StreamWriter("D:\\out.txt", true);
            wr.WriteLine(URL);

            var lst_query = RDFQuery.GetData(RDFQuery.QueryType.SettlementInfo, new string[] { URL });
            foreach (var elem in lst_query)
            {
                //name nameOfRegion nameOfType hasBeginning lat long population populationOfMan populationOfWoman year source
                Settlement settlement = lst_settlements[FindByURL(URL)];
                settlement.Type = elem["nameOfType"] != null ? elem["nameOfType"].ToString() : null;
                settlement.Year = elem["year"] != null ? elem["year"].ToString() : null;
                settlement.Region = elem["nameOfRegion"] != null ? elem["nameOfRegion"].ToString() : null;
                settlement.Population = elem["population"] != null ? elem["population"].ToString() : "0";
                settlement.PopulationOfMan = elem["populationOfMan"] != null ? elem["populationOfMan"].ToString() : null;
                settlement.PopulationOfWoman = elem["populationOfWoman"] != null ? elem["populationOfWoman"].ToString() : null;
                settlement.Description = u.ToString();
                settlement.Source = elem["source"] != null ? elem["source"].ToString() : null;

                u++;
                wr.Close();
                //lst_settlements.Add(new_settlement);
            }
        }

        #endregion

        #region Public Methods

        public bool Update
        {
            get { return needUpdate; }
            set { if (value) needUpdate = true; }
        }

        public Settlement[] GetSettlements(int YearMin, int YearMax)
        {
            if (needUpdate)
            {
                Clear();
                LoadAllSettlements(YearMin.ToString(), YearMax.ToString());
                needUpdate = false;
            }
            return lst_settlements.ToArray();
        }

        public Settlement GetInfoAboutSettlement(string URL)
        {
            Settlement settlement = lst_settlements[FindByURL(URL)];
            
            //  Условия, которые проверят наличие данных о поселении
            //  Если данных нет (кроме имени и координат), нужно выполнить их загрузку
            if (settlement.Type == null)
            {
                LoadInfoAboutSettlement(URL);
            }
            return settlement;
        }

        public string[] GetSettlementsNames(string subName)
        {
            var lst_query = RDFQuery.GetData(RDFQuery.QueryType.SubName, new string[] { subName });
            List<string> result = new List<string>();
            foreach (var elem in lst_query)
                result.Add(elem["name"].ToString());
            
            return result.ToArray();
        }

        #region Tools

        private void Clear()
        {
            lst_settlements = new List<Settlement>();
        }

        private int FindByName(string name)
        {
            for (int i = 0; i < lst_settlements.Count; i++)
            {
                if (lst_settlements[i].Name == name)
                    return i;
            }
            return -1;
        }

        private int FindByURL(string URL)
        {
            for (int i = 0; i < lst_settlements.Count; i++)
            {
                if (lst_settlements[i].URL == URL)
                    return i;
            }
            return -1;
        }

        #endregion

        #endregion

    }
}
