﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModelData.BusinessModel
{
    public class Settlement
    {
        /// <summary>
        /// Первичный ключ.
        /// </summary>
        public string URL { set; get; }

        public string Name { set; get; }
        public Position position { set; get; }

        public string Year { set { if (value.Contains('^')) year = value.Split('^')[0]; else year = value; } get { return year; }}
        public string Type { set; get; }
        public string Population { set { if (value.Contains('^')) population = value.Split('^')[0]; else population = value; } get { return population; } }
        public string PopulationOfMan { set { if (value.Contains('^')) populationOfMan = value.Split('^')[0]; else populationOfMan = value; } get { return populationOfMan; } }
        public string PopulationOfWoman { set { if (value.Contains('^')) populationOfWoman = value.Split('^')[0]; else populationOfWoman = value; } get { return populationOfWoman; } }
        public string Region { set; get; }
        public string Description { set; get; }
        public string Source { set; get; }

        private string year;
        private string population;
        private string populationOfMan;
        private string populationOfWoman;

        public List<SettlementName> Names { set; get; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="url_">URL однозначно указывает на объект (поселение).</param>
        /// <param name="name_">Отображаемое имя.</param>
        /// <param name="position_">Координаты поселения.</param>
        public Settlement(string url_, string name_, Position position_) 
        {
            this.URL = url_;
            this.Name = name_;
            this.position = position_;           
        }

        public override string ToString()
        {
            string t = URL + "\n" + Name + "\n" + position + "\n" + Year + "\n" + Type + "\n" + Population + "\n" + PopulationOfMan + "\n" + PopulationOfWoman + "\n" + Region + "\n" + Description;
            return t;
        }

    }

    public class SettlementName
    {
        public string Name { set; get; }
        public TimeInterval Interval { set; get; }

        public SettlementName(){ }
        public SettlementName(string name_, string start_)
        {
            this.Name = name_;
            this.Interval = new TimeInterval(start_);
        }
        public SettlementName(string name_, string start_, string end_)
        {
            this.Name = name_;
            this.Interval = new TimeInterval(start_, end_);
        }
    }

    public class TimeInterval
    {
        public string Start { set; get; }
        public string End { set; get; }

        public TimeInterval(){ }
        public TimeInterval(string start_)
        {
            this.Start = start_;
        }
        public TimeInterval(string start_, string end_)
        {
            this.Start = start_;
            this.End = end_;
        }
    }
}
