﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VDS.RDF;
using VDS.RDF.Query;
using VDS.RDF.Parsing;
using VDS.RDF.Writing;

namespace ModelData.BusinessModel.RDF
{
    public class RDFQuery
    {        
        private const string SPARQL_Query_Endpoint = "http://jena.denhome.keenetic.link/map/query";

        public enum QueryType { MinYear, AllSettlements, SettlementInfo, SubName };

        /// <summary>
        /// Получить результат запроса к SPARQL точке.
        /// </summary>
        /// <param name="queryType">Тип запроса. Обязателен</param>
        /// <param name="args">Параметры запроса. В зависимости от типа запроса обязателен или нет</param>
        /// <returns></returns>
        public static List<SparqlResult> GetData(QueryType queryType, string[] args = null)
        {
            string exQuery = "";
            try
            {
                switch (queryType)
                {
                    case QueryType.MinYear: { exQuery = Queries.MinYear(); } break;
                    case QueryType.AllSettlements: { exQuery = Queries.AllSettlementsInInterval(args[0], args[1]); } break;
                    case QueryType.SettlementInfo: { exQuery = Queries.InfoAboutSettlement(args[0]); } break;
                    case QueryType.SubName: { exQuery = Queries.AllSettlementsName(args[0]); } break;
                    default: throw new Exception("Invalid argument: queryType = " + queryType.ToString());
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                Console.ReadKey();
                throw;
            }
            //Create endpoint and make our query
            SparqlRemoteEndpoint endpoint = new SparqlRemoteEndpoint(new Uri(SPARQL_Query_Endpoint));
            SparqlResultSet results = endpoint.QueryWithResultSet(exQuery);

            return results.Results;
        }
    }
}
