﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModelData.BusinessModel.RDF
{
    public class Queries
    {
        private Queries() { }

        #region Prefixes

        private static readonly Dictionary<string, string> Prefixes = new Dictionary<string, string>
        {
            ["rdf"] = "<http://www.w3.org/1999/02/22-rdf-syntax-ns#>",
            ["rdfs"] = "<http://www.w3.org/2000/01/rdf-schema#>",
            ["owl"] = "<http://www.w3.org/2002/07/owl#>",
            ["xsd"] = "<http://www.w3.org/2001/XMLSchema#>",
            ["geo"] = "<http://www.w3.org/2003/01/geo/wgs84_pos#>",
            ["geonames"] = "<http://www.geonames.org/ontology#>",
            ["time"] = "<https://www.w3.org/2006/time#>",
            ["map"] = "<http://jena.denhome.keenetic.link/map#>"
        };               

        #endregion

        #region Queries

        public static string AllSettlementsInInterval(string from, string to)
        {
            return GetPrefix("map") + GetPrefix("geo") + GetPrefix("geonames") +
@"
SELECT distinct ?settlement ?name ?population ?lat ?long 
WHERE {
  ?settlement a map:Settlement; geonames:name ?name;geo:lat ?lat; geo:long ?long.
  OPTIONAL { ?settlement geonames:population ?population}
}
";
        }

        public static string InfoAboutSettlement(string URL)
        {
            string url_ = GetObjFromURL(URL);

            return GetAllPrefixes() +
@"
SELECT distinct ?name ?nameOfRegion ?nameOfType ?hasBeginning ?lat ?long ?population ?populationOfMan ?populationOfWoman ?year ?source

WHERE {
  "+ url_ + @" a map:Settlement.
  OPTIONAL { "+ url_ + @" geonames:name ?name.}
  OPTIONAL { "+ url_ + @" rdfs:partOf ?region. ?region geonames:name ?nameOfRegion }
  OPTIONAL { "+ url_ + @" map:hasSettlementType ?hasSettlementType. ?hasSettlementType geonames:name ?nameOfType }
  OPTIONAL { "+ url_ + @" time:hasBeginning ?hasBeginning}
  OPTIONAL { "+ url_ + @" geo:lat ?lat}
  OPTIONAL { "+ url_ + @" geo:long ?long}
  OPTIONAL { "+ url_ + @" geonames:population ?population}
  OPTIONAL { "+ url_ + @" map:populationOfMan ?populationOfMan}
  OPTIONAL { "+ url_ + @" map:populationOfWoman ?populationOfWoman}
  OPTIONAL { "+ url_ + @" time:year ?year}
  OPTIONAL { "+ url_ + @" map:source ?source}
}
";
        }

        public static string AllSettlementsName(string subName)
        {
            return GetPrefix("map") + GetPrefix("geonames") +
@"
select distinct ?name
where
{
  ?settlement a map:Settlement; geonames:name ?name.
  FILTER regex(?name, " + '"' + subName + "\", \"i\"" + @")
}
";
        }

        public static string MinYear()
        {
            return GetAllPrefixes() +
@"

";
        }

        #endregion

        #region Tools

        private static string GetObjFromURL(string URL)
        {
            string[] input = URL.Split('#');
            string url_ = "";
            foreach (var item in Prefixes)
                if (item.Value.Contains(input[0]))
                {
                    url_ = item.Key + ":" + input[1];
                    break;
                }
            return url_;
        }

        private static string GetPrefix(string key)
        {
            return "PREFIX " + key + ": " + Prefixes[key] + " ";
        }

        private static string GetAllPrefixes()
        {
            string t = "";
            foreach (var item in Prefixes)
            {
                t += "PREFIX " + item.Key + ": " + Prefixes[item.Key] + " ";
            }
            return t;
        }

        #endregion
    }

}

/*
 insert data
{
  map:TatishchevskijRegion a map:Region; geonames:name "Татищевский район".
}
     
     
     */

/*
FILTER regex(?name, "^ali", "i")
^ дает указаение, что искомое стоит в начале слова == "Alice"
FILTER regex(str(?mbox), "@work.example")
@ дает указаение, что искомое стоит в конце слова == <mailto:alice@work.example>
i - параметр, указывающий что регистр поиска не важен
ПОИСК (по regex) здесь: https://www.w3.org/TR/rdf-sparql-query/
 */

