﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.RDF;
using ModelData.BusinessModel.MainEntities;
using ModelData.BusinessModel.ExtraEntities;

namespace ModelData.BusinessModel.UnitOfWork
{
    public class Context
    {

        public IEnumerable<Settlement> settlements { set; get; }
        //public IEnumerable<EditedSettlement> editedSettlements { set; get; }


        private void LoadAllSettlements(string YearMin, string YearMax)
        {
            var lst_query = RDFQuery.GetData(RDFQuery.QueryType.AllSettlements, new string[] { YearMin, YearMax });
            Settlement settlement;

            foreach (var elem in lst_query)
            {
                int pop = int.Parse(elem["population"].ToString().Split('^')[0]);
                settlement = new Settlement(elem["settlement"].ToString(), elem["name"].ToString(), new Position(elem["long"], elem["lat"]))
                {
                    Population = elem["population"] != null ? elem["population"].ToString() : "0"
                };
                lst_settlements.Add(settlement);
            }
        }

        static int u = 0;
        private void LoadInfoAboutSettlement(string URL)
        {
            System.IO.StreamWriter wr = new System.IO.StreamWriter("D:\\out.txt", true);
            wr.WriteLine(URL);

            var lst_query = RDFQuery.GetData(RDFQuery.QueryType.SettlementInfo, new string[] { URL });
            foreach (var elem in lst_query)
            {
                //name nameOfRegion nameOfType hasBeginning lat long population populationOfMan populationOfWoman year source
                Settlement settlement = lst_settlements[FindByURL(URL)];
                settlement.Type = elem["nameOfType"] != null ? elem["nameOfType"].ToString() : null;
                settlement.Year = elem["year"] != null ? elem["year"].ToString() : null;
                settlement.Region = elem["nameOfRegion"] != null ? elem["nameOfRegion"].ToString() : null;
                settlement.Population = elem["population"] != null ? elem["population"].ToString() : "0";
                settlement.PopulationOfMan = elem["populationOfMan"] != null ? elem["populationOfMan"].ToString() : null;
                settlement.PopulationOfWoman = elem["populationOfWoman"] != null ? elem["populationOfWoman"].ToString() : null;
                settlement.Description = u.ToString();
                settlement.Source = elem["source"] != null ? elem["source"].ToString() : null;

                u++;
                wr.Close();
                //lst_settlements.Add(new_settlement);
            }
        }

        #region Tools

        private void Clear()
        {
            lst_settlements = new List<Settlement>();
        }

        private int FindByName(string name)
        {
            for (int i = 0; i < lst_settlements.Count; i++)
            {
                if (lst_settlements[i].Name == name)
                    return i;
            }
            return -1;
        }

        private int FindByURL(string URL)
        {
            for (int i = 0; i < lst_settlements.Count; i++)
            {
                if (lst_settlements[i].URL == URL)
                    return i;
            }
            return -1;
        }

        #endregion

    }
}
