﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.BaseAndInterface;
using Tools;

namespace ModelData.BusinessModel.ExtraEntities
{
    /// \addtogroup Entities
    /// @{

    /// \class  SettlementType
    ///
    /// \brief  Отражает сущность типа поселения
    /// Включает описание типа поселений, например промежуток количества населения для данного типа, и другие названия данного типа.
    /// \author Denis
    /// \date   30.03.2019

    public class SettlementType:BaseOntologyEntity 
    {
        /// \property   public string Description
        ///
        /// \brief  Описание типа поселения
        /// Установлен атрибут IndexAttrib со значением 2
        /// \returns    The description.

        [IndexAttrib(2)] public string Description { set; get; }



        /// \property   public List<string> AlternativeName
        ///
        /// \brief  Набор альтернативных названий текущего типа поселения
        /// Установлен атрибут IndexAttrib со значением 3
        /// \returns    The name of the alternative.

        [IndexAttrib(3)] public List<string> AlternativeName { set; get; }



        /// \fn public override Dictionary<string,string> Serialize()
        ///
        /// \brief  Метод записи данных о сущности в Dictionary.
        ///
        /// \author Denis
        /// \date   30.03.2019
        ///
        /// \returns    A Dictionary&lt;string,string&gt;

        public override Dictionary<string,string> Serialize()
        {
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Название"] = this.Title ?? "",
                ["Описание"] = this.Description ?? "",
                ["Другое название"] = Concat(this.AlternativeName)
            };
        }
    }
    /// @}
}
