﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.BaseAndInterface;
using Tools;


namespace ModelData.BusinessModel.ExtraEntities
{
    /// \addtogroup Entities
    /// @{

    /// \class  Region
    ///
    /// \brief  Класс, отражающий сущность административно-территориальной единицы (региона)
    /// Помимо наследуемых свойств, обладает свойством включения в другой регион.
    /// \author Denis
    /// \date   30.03.2019

    public class Region : BaseOntologyEntity
    {
        /// \property   public Region partOfRegion
        ///
        /// \brief  Регион, в состав которого входит данная сущность (тоже регион)
        /// Установлен атрибут IndexAttrib со значением 2
        /// \returns    The part of region.

        [IndexAttrib(2)] public Region partOfRegion { set; get; }



        /// \fn public override Dictionary<string, string> Serialize()
        ///
        /// \brief  Метод записи данных о сущности в Dictionary.
        ///
        /// \author Denis
        /// \date   30.03.2019
        ///
        /// \returns    A Dictionary&lt;string,string&gt;

        public override Dictionary<string, string> Serialize()
        {
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Название"] = this.Title ?? "",               
                ["Является частью региона"] = this.partOfRegion?.Title ?? ""
            };
        }
    }
    /// @}
}
