﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModelData.BusinessModel.Tools
{
    /// \addtogroup Entities
    /// @{

    /// \class  InstantTime
    ///
    /// \brief  Сущность точного года
    /// Используется в качестве минимальной временной единицы согласно онтологической модели.
    /// \warning Кажется тут я накосячил с тем, что нельзя присвоить год вручную.
    /// \todo Сделать set value, где вызывается Init(int?).
    /// \author Denis
    /// \date   31.03.2019

    public class InstantTime
    {

        /// \brief  Скрытое поле, содержащее год
        private int? year;

        /// \property   public int? Year
        ///
        /// \brief  Получить значение года
        ///
        /// \returns    The year.

        public int? Year
        {
            get { return year; }
        }



        /// \fn public InstantTime()
        ///
        /// \brief  Стандартный конструктор
        /// Год принимает значение null. Требуется присвоить значение       
        /// \author Denis
        /// \date   31.03.2019

        public InstantTime() { }



        /// \fn public InstantTime(int? year)
        ///
        /// \brief  Конструктор на основе целочисленного года
        /// Вызов метода Init(int?)
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \param  year    The year.

        public InstantTime(int? year)
        {
            Init(year);
        }



        /// \fn public InstantTime(string year)
        ///
        /// \brief  Конструктор на основе строкового года
        /// Вызов метода Init(string)
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \param  year    The year.

        public InstantTime(string year)
        {
            if (year == null)
            {
                this.year = null;
                return;
            }
                
            Init(year);
        }



        /// \fn private void Init(int? year)
        ///
        /// \brief  Присваивает значение закрытому полю
        /// Если переданное значение = null, значение поля становится null
        /// Иначе проверяется значение: год не может быть меньше 2000 до н.э. и больше текущего года.
        /// Если проверка не пройдена, году устанавливается значение текущего года.
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \param  year    The year.

        private void Init(int? year)
        {
            if (year.HasValue)
                this.year = (year > -2000 && year < (DateTime.Now.Year + 1)) ? (year) : (DateTime.Now.Year);
            else
                this.year = null;
        }



        /// \fn private void Init(string year)
        ///
        /// \brief  Присваивает значение закрытому полю
        /// Преобразует строковое значение в целочисленное и вызывает метод Init(int?)
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \param  year    The year.

        private void Init(string year)
        {
            this.Init(int.Parse(year));
        }



        /// \fn public override string ToString()
        ///
        /// \brief  Возвращает строку, представляющую текущий объект.
        /// Будучи базовой сущностью (не унаследованной от BaseOntologyEntity) требует преобразования в строку.
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \returns    Строка, представляющая текущий объект.

        public override string ToString()
        {
            return Year.ToString();
        }
    }
    /// @}
}
