﻿ymaps.ready(MapInit);

function MapInit()
{
    console.log("MapInit");
    YandexMapInit();
    CollectionsInit();
    GetDate(true);    
}

var Collections;
var CollectionVisible;

var Map;
var CurrentZoom;
var MinYear;
var MaxYear;
var CurrentMinYear;
var CurrentMaxYear;
//var clusterer;

//  Функция загрузки Яндекс карты
function YandexMapInit()
{
    Map = new ymaps.Map
        ('map', {
            center: [51.533103, 46.034158],
            zoom: 8,
            type: 'yandex#satellite'/*'yandex#hybrid'*/,
            controls: ['zoomControl', 'rulerControl']
        },
        {
            // Ограничим область карты.
            restrictMapArea: [[48.795, 41.484], [53.823, 51.856]]
            //restrictMapArea: [[49.795, 42.484], [52.823, 50.856]]
        }
    );
    CurrentZoom = Map.action.getCurrentState().zoom;
    Map.controls.get('zoomControl').options.set({ size: 'auto' });
    Map.controls.add(new ymaps.control.TypeSelector(['yandex#map', 'yandex#satellite'/*, 'yandex#hybrid'*/]));

    // Будем отслеживать зум карты при смене видимых границ (движение карты и смена zoom)
    Map.events.add('boundschange', function (event)
    {
        CurrentZoom = event.get('newZoom');       
        if (CurrentZoom != event.get('oldZoom'))
        {
            //console.log(event.get('oldZoom') + " " + CurrentZoom);
            SelectDataFromArrays(true, true);
        }
    });

    // Загрузим регионы.
    ymaps.borders.load
        ('RU', { lang: 'ru', quality: 3 }).then
        (function (result) {
            // Создадим многоугольник, который будет скрывать весь мир, кроме заданной области.
            var background = new ymaps.Polygon
                (
                [[
                    [85, -179.99],
                    [85, 179.99],
                    [-85, 179.99],
                    [-85, -179.99],
                    [85, -179.99]
                ]],
                {},
                {
                    fillColor: '#c3c3c3',
                    strokeWidth: 0,
                    // Для того чтобы полигон отобразился на весь мир, нам нужно поменять
                    // алгоритм пересчета координат геометрии в пиксельные координаты.
                    coordRendering: 'straightPath'
                }
                );

            // Найдём область по её iso коду.
            var region = result.features.filter(function (feature) { return feature.properties.iso3166 == 'RU-SAR'; })[0];
            // Добавим координаты этой области в полигон, который накрывает весь мир.
            // В полигоне образуется полость, через которую будет видно заданную область.
            var masks = region.geometry.coordinates;

            masks.forEach(function (mask) { background.geometry.insert(1, mask); });
            // Добавим многоугольник на карту.
            Map.geoObjects.add(background);
        });    

    // центрирование карты
    //myMap.setCenter(coord, 13);

    //Создание кластера
    //clusterer = new ymaps.Clusterer({
    //    /**
    //     * Через кластеризатор можно указать только стили кластеров,
    //     * стили для меток нужно назначать каждой метке отдельно.
    //     * @see https://api.yandex.ru/maps/doc/jsapi/2.1/ref/reference/option.presetStorage.xml
    //     */
    //    preset: 'islands#invertedVioletClusterIcons',
    //    /**
    //     * Ставим true, если хотим кластеризовать только точки с одинаковыми координатами.
    //     */
    //    groupByCoordinates: false,
    //    /**
    //     * Опции кластеров указываем в кластеризаторе с префиксом "cluster".
    //     * @see https://api.yandex.ru/maps/doc/jsapi/2.1/ref/reference/ClusterPlacemark.xml
    //     */
    //    clusterDisableClickZoom: true,
    //    clusterHideIconOnBalloonOpen: false,
    //    geoObjectHideIconOnBalloonOpen: false
    //});
    //clusterer.options.set({
    //    gridSize: 500,
    //    clusterDisableClickZoom: true
    //});

}

//  Функция создания слайдера дат и обработчик поля ввода дат
function SliderInit() {
    var slider = $("#slider").rangeSlider({
        bounds: { min: MinYear, max: MaxYear },
        defaultValues: { min: CurrentMinYear, max: CurrentMaxYear },
        arrows: true,
        symmetricPositionning: true,
        step: 1
    });
    //"valuesChanged" для ручного и машинного изменения
    //"userValuesChanged" для ручного изменения
    $("#slider").bind("valuesChanged", function (e, data) {
        SliderOnFinishMoving(data.values);
    });   

    //  Поле ввода меньшей даты. Обработчик изменения дат слайдера
    var inputFieldMinYear = document.getElementById('inputMinYear');
    inputFieldMinYear.oninput = function () {
        if (inputFieldMinYear.value <= MaxYear && inputFieldMinYear.value >= MinYear) {
            $("#slider").rangeSlider("values", inputFieldMinYear.value - 0, $("#slider").rangeSlider("values").max);
        }
    };

    //  Поле ввода большей даты. Обработчик изменения дат слайдера
    var inputFieldMaxYear = document.getElementById('inputMaxYear');
    inputFieldMaxYear.oninput = function () {
        if (inputFieldMaxYear.value <= MaxYear && inputFieldMaxYear.value >= MinYear) {
            $("#slider").rangeSlider("values", $("#slider").rangeSlider("values").min, inputFieldMaxYear.value - 0);
        }
    };

    //  Обработчик кнопки поиска по имени
    $('#buttonSearch').bind('click', function () {
        var resultName = document.getElementById('inputName').value;
        if (resultName.length != 0)
            OnFindNameUsing(resultName);
    });

    //  Обработчик кнопки скорытия боковой панели
    $('#sidebar-close').bind('click', function () {
        $('#sidebar, #content').addClass('active');
        $('.collapse.in').toggleClass('in');
        $('a[aria-expanded=true]').attr('aria-expanded', 'false');
    });
}

function AutoCompleteInit(data) {
    $('input#inputName').autocomplete({
        source: function (request, response) {
            var term = request.term;
            var pattern = new RegExp("^" + term, "i");

            var results = $.map(data, function (elem) {
                if (pattern.test(elem)) {
                    return elem;
                }
            })
            response(results.slice(0, 10));
        },
        //source: function (request, response) {
        //    var results = $.ui.autocomplete.filter(data, request.term);

        //    response(results.slice(0, 10));
        //},
        minLength: 2,
        delay: 300,
        select: function(event, ui) {
            //$('#sku').val(skus[ui.item.value]);
            OnFindNameUsing(ui.item.value)
        }
    });}

//  Функция создания коллекций Яндекс-объектов
function CollectionsInit() {
    //  Набор массивов, которые формируются для более гибкого отображения данных на странице.
    //  Являются параметрами глобальной переменной-объекта.

    Collections = new Object();
    Collections.All = new Array();
    Collections.SettlementTypes = new Array();
    Collections.Regions = new Array();
    Collections.Zoom_8 = new Array();
    Collections.Zoom_9 = new Array();
    Collections.Zoom_10 = new Array();
    Collections.Zoom_11 = new Array();
    Collections.Zoom_12 = new Array();
    Collections.Zoom_13 = new Array();
    Collections.Zoom_14 = new Array();
    Collections.Zoom_15 = new Array();
    Collections.Zoom_16 = new Array();
    Collections.Zoom_17 = new Array();
    Collections.Zoom_18 = new Array();
    Collections.Zoom_19 = new Array();
    Collections.FindName = new Array();
    Collections.Names = new Array();
    Collections.Export = new Array();
    //  Коллекция для отражения данных на карте.
    CollectionVisible = new ymaps.GeoObjectCollection({},
        {
            //  Параметр коллекции всех элементов, отображающий название в красной рамке
            preset: 'islands#redStretchyIcon'
        });
}