﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VDS.RDF;
using VDS.RDF.Query;
using VDS.RDF.Parsing;
using VDS.RDF.Writing;

using Tools.Config;

namespace ModelData.BusinessModel.RDF
{
    public class RDFQuery
    {     
        public enum QueryType { Years, AllSettlements, SettlementInfo, SubName };

        /// <summary>
        /// Получить результат запроса к SPARQL точке.
        /// </summary>
        /// <param name="queryType">Тип запроса. Обязателен</param>
        /// <param name="args">Параметры запроса. В зависимости от типа запроса обязателен или нет</param>
        /// <returns></returns>
        public static List<SparqlResult> GetData(QueryType queryType, string[] args = null)
        {
            string exQuery;
            string endpointURI;
            var Config = ConfigManager.Get();
            try
            {
                switch (queryType)
                {
                    case QueryType.Years:
                        {
                            exQuery = Queries.Years();
                            endpointURI = Config.SPARQL_Query_Endpoint;
                        } break;
                    case QueryType.AllSettlements:
                        {
                            exQuery = Queries.AllSettlementsInInterval(args[0], args[1]);
                            endpointURI = Config.SPARQL_Query_Endpoint;
                        } break;
                    case QueryType.SettlementInfo:
                        {
                            exQuery = Queries.InfoAboutSettlement(args[0]);
                            endpointURI = Config.SPARQL_Query_Endpoint;
                        } break;
                    case QueryType.SubName:
                        {
                            exQuery = Queries.AllSettlementsName(args[0]);
                            endpointURI = Config.SPARQL_Query_Endpoint;
                        } break;
                    default: throw new Exception("Invalid argument: queryType = " + queryType.ToString());
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                Console.ReadKey();
                throw;
            }
            //Create endpoint and make our query
            SparqlRemoteEndpoint endpoint = new SparqlRemoteEndpoint(new Uri(endpointURI));
            SparqlResultSet results = endpoint.QueryWithResultSet(exQuery);

            return results.Results;
        }
    }
}
