﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.Tools;
using ModelData.BusinessModel.ExtraEntities;
using ModelData.BusinessModel.BaseAndInterface;

namespace ModelData.BusinessModel.MainEntities
{
    public class Settlement : BaseOntologyEntity
    {
        #region Обязательные данные

        //  URL

        //  Title

        public Coordinate Coordinate { set; get; }

        #endregion

        #region Необязательные данные

        public InstantTime hasBeginning { set; get; }
        public Founder Founder { set; get; }
        public string Legend { set; get; }
        public Dictionary<string, string> Others { set; get; }

        #endregion

        #region Служебные данные

        public List<EditedSettlement> EditedSettlements { set; get; }

        #endregion

        #region Конструктор

        protected Settlement()
        {
            Init();
        }

        public Settlement(string URL, string Title, Coordinate Coordinate)
        {
            this.URL = URL;
            this.Title = Title;
            this.Coordinate = Coordinate;

            Init();
        }

        protected void Init()
        {
            Others = new Dictionary<string, string>();
            EditedSettlements = new List<EditedSettlement>();
        }

        #endregion       
    }
}
