﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModelData.BusinessModel.Tools
{
    public class InstantTime
    {
        private int? year;

        public int? Year
        {
            get { return year; }
        }

        public InstantTime() { }
        public InstantTime(int? year)
        {
            Init(year);
        }
        public InstantTime(string year)
        {
            if (year == null)
            {
                this.year = null;
                return;
            }
                
            Init(year);
        }

        private void Init(int? year)
        {
            if (year.HasValue)
                this.year = (year > -2000 && year < (DateTime.Now.Year + 1)) ? (year) : (DateTime.Now.Year);
            else
                this.year = null;
        }
        private void Init(string year)
        {
            this.Init(int.Parse(year));
        }

        public override string ToString()
        {
            return Year.ToString();
        }
    }
}
