﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel;
using ModelData.BusinessModel.MainEntities;

namespace ModelData.WebModel
{
    public class WebDataManager
    {
        #region singl

        private static WebDataManager dataManager;
        public static WebDataManager Get()
        {
            if (dataManager == null)
                dataManager = new WebDataManager();

            return dataManager;
        }
        public static void Destroy()
        {
            dataManager = null;
        }

        private WebDataManager()
        {
            Init();
        }

        #endregion

        #region Data
        #endregion

        #region Methods

        public Model GetMapPoints(int YearMin, int YearMax)
        {
            Model model = new Model();

            int maxPop = 0, pop;
            List<string> temp = new List<string>();

            BusinessDataManager businessData = BusinessDataManager.Get();
            var context = businessData.GetSettlements(YearMin, YearMax);

            model.arraySettlements = context.MapPoints.ToArray();

            foreach (var type in context.SettlementTypes)
                temp.Add(type.Title);
            model.arrayNameTypes = temp.ToArray();
            temp.Clear();

            foreach (var region in context.Regions)
                temp.Add(region.Title);
            model.arrayNameRegions = temp.ToArray();
            temp.Clear();           

            foreach (var settlement in context.MapPoints)
            {
                pop = int.Parse(settlement.Population);
                if (pop > maxPop) maxPop = pop;

                temp.Add(settlement.Title);
            }

            model.InitZoom(maxPop);

            return model;
        }

        public Settlement GetSettlement(string URL)
        {
            BusinessDataManager businessData = BusinessDataManager.Get();

            return businessData.GetInfoAboutSettlement(URL);
        }

        public string[] GetSettlementsNames(string subName)
        {
            BusinessDataManager businessData = BusinessDataManager.Get();

            return businessData.GetSettlementsNames(subName);
        }

        public (int min, int max) GetYears()
        {
            BusinessDataManager businessData = BusinessDataManager.Get();

            return businessData.GetYears();
        }

        #region Tools

        private void Init(int Count = 5)
        {            
        }
        #endregion

        #endregion

    }
}
