﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.Tools;
using ModelData.BusinessModel.BaseAndInterface;
using ModelData.BusinessModel.ExtraEntities;

namespace ModelData.BusinessModel.MainEntities
{
    public class EditedSettlement : BaseOntologyEntity
    {
        #region Обязательные данные

        //  URL

        public Settlement before { set; get; }
        public InstantTime hasBeginning { set; get; }
        public string Source { set; get; }

        #endregion

        #region Необязательные данные

        //  Title
        
        public SettlementType Type { set; get; }
        public Region Region { set; get; }
        public int? PopulationAll { set; get; }
        public int? PopulationMales { set; get; }
        public int? PopulationFemales { set; get; }
        public List<string> AlternativeName { set; get; }
        public Dictionary<string, string> Others { set; get; }

        #endregion

        #region Конструктор

        protected EditedSettlement()
        {
            Init();
        }

        public EditedSettlement(string URL, Settlement before, InstantTime hasBeginning, string Source)
        {
            this.URL = URL;
            this.before = before;
            this.hasBeginning = hasBeginning;
            this.Source = Source;

            Init();
        }

        protected void Init()
        {
            AlternativeName = new List<string>();
            Others = new Dictionary<string, string>();
        }

        #endregion
    }
}
