﻿ymaps.ready(MapInit);

function MapInit()
{
    console.log("MapInit");
    YandexMapInit();
    CollectionsInit();
    GetDate();    
    SliderInit();    
    GetAllPoints(CurrentMinYear, CurrentMaxYear);
}

var Collections;
var CollectionVisible;

var Map;
var CurrentZoom;
var MinYear;
var MaxYear;
var CurrentMinYear;
var CurrentMaxYear;
//var clusterer;

var ConstPopulation = Object.freeze({
    10000: "Zoom_8",
    5000: "Zoom_9",
    1000: "Zoom_10",
    800: "Zoom_11",
    600: "Zoom_12",
    400: "Zoom_13",
    200: "Zoom_14",
    100: "Zoom_15",
    60: "Zoom_16",
    20: "Zoom_17",
    10: "Zoom_18",
    0: "Zoom_19"
});

//  Функция загрузки Яндекс карты
function YandexMapInit()
{
    Map = new ymaps.Map
        ('map', {
            center: [51.533103, 46.034158],
            zoom: 8,
            type: 'yandex#satellite'/*'yandex#hybrid'*/,
            controls: ['zoomControl', 'rulerControl']
        },
        {
            // Ограничим область карты.
            restrictMapArea: [[48.795, 41.484], [53.823, 51.856]]
            //restrictMapArea: [[49.795, 42.484], [52.823, 50.856]]
        }
    );
    CurrentZoom = Map.action.getCurrentState().zoom;
    Map.controls.get('zoomControl').options.set({ size: 'auto' });
    Map.controls.add(new ymaps.control.TypeSelector(['yandex#map', 'yandex#satellite'/*, 'yandex#hybrid'*/]));

    // Будем отслеживать зум карты при смене видимых границ (движение карты и смена zoom)
    Map.events.add('boundschange', function (event)
    {
        CurrentZoom = event.get('newZoom');       
        if (CurrentZoom != event.get('oldZoom'))
        {
            //console.log(event.get('oldZoom') + " " + CurrentZoom);
            SelectDataFromArrays(true, true);
        }
    });

    // Загрузим регионы.
    ymaps.borders.load
        ('RU', { lang: 'ru', quality: 3 }).then
        (function (result) {
            // Создадим многоугольник, который будет скрывать весь мир, кроме заданной области.
            var background = new ymaps.Polygon
                (
                [[
                    [85, -179.99],
                    [85, 179.99],
                    [-85, 179.99],
                    [-85, -179.99],
                    [85, -179.99]
                ]],
                {},
                {
                    fillColor: '#ffffff',
                    strokeWidth: 0,
                    // Для того чтобы полигон отобразился на весь мир, нам нужно поменять
                    // алгоритм пересчета координат геометрии в пиксельные координаты.
                    coordRendering: 'straightPath'
                }
                );

            // Найдём область по её iso коду.
            var region = result.features.filter(function (feature) { return feature.properties.iso3166 == 'RU-SAR'; })[0];
            // Добавим координаты этой области в полигон, который накрывает весь мир.
            // В полигоне образуется полость, через которую будет видно заданную область.
            var masks = region.geometry.coordinates;

            masks.forEach(function (mask) { background.geometry.insert(1, mask); });
            // Добавим многоугольник на карту.
            Map.geoObjects.add(background);
        });    


    //Создание кластера
    //clusterer = new ymaps.Clusterer({
    //    /**
    //     * Через кластеризатор можно указать только стили кластеров,
    //     * стили для меток нужно назначать каждой метке отдельно.
    //     * @see https://api.yandex.ru/maps/doc/jsapi/2.1/ref/reference/option.presetStorage.xml
    //     */
    //    preset: 'islands#invertedVioletClusterIcons',
    //    /**
    //     * Ставим true, если хотим кластеризовать только точки с одинаковыми координатами.
    //     */
    //    groupByCoordinates: false,
    //    /**
    //     * Опции кластеров указываем в кластеризаторе с префиксом "cluster".
    //     * @see https://api.yandex.ru/maps/doc/jsapi/2.1/ref/reference/ClusterPlacemark.xml
    //     */
    //    clusterDisableClickZoom: true,
    //    clusterHideIconOnBalloonOpen: false,
    //    geoObjectHideIconOnBalloonOpen: false
    //});
    //clusterer.options.set({
    //    gridSize: 500,
    //    clusterDisableClickZoom: true
    //});

}

//  Функция создания слайдера дат и обработчик поля ввода дат
function SliderInit() {
    // $j optional alias to jQuery noConflict()
    var $j = jQuery.noConflict();
    var $slider;

    $j(document).ready(function () {
        $slider = $("#slider").ionRangeSlider({
            skin: "modern",
            hide_min_max: true,
            type: "double",
            grid: true,
            drag_interval: true,
            min: MinYear,
            max: MaxYear,
            from: CurrentMinYear,
            to: new Date().getFullYear(),
            onFinish: function (data) {
                console.log("finish");
                // Вызывается, когда пользователь перетсал двигать ползунок слайдера
                SliderOnFinishMoving(data);
            },
            onUpdate: function (data) {
                console.log("update");
                // Вызывается, когда значение слайдера изменилось с помощью некоторой функции (см. обработчик inputField)
                SliderOnFinishMoving(data);
            }
        });
    });
    //  Поле ввода даты. Обработчик изменения дат слайдера
    var inputFieldYear = document.getElementById('inputYear');
    inputFieldYear.oninput = function () {
        if (inputFieldYear.value <= MaxYear && inputFieldYear.value >= MinYear) {
            var slider_instance = $slider.data("ionRangeSlider");
            slider_instance.update({
                from: inputFieldYear.value,
                to: inputFieldYear.value
            });
        }
    };
    //  Обработчик кнопки поиска по имени
    $('#buttonSearch').bind('click', function () {
        //alert($(this).text());
        var resultName = document.getElementById('inputName').value;
        if (resultName.length != 0)
            OnFindNameUsing(resultName);
    });
}

function AutoCompleteInit(data) {
    $('input#inputName').autocomplete({
        source: function (request, response) {
            var results = $.ui.autocomplete.filter(data, request.term);
            var value = document.getElementById('NameCount').value;
            if (isNaN(value) || value <= 0)
                value = 10;

            response(results.slice(0, value));
        },
        minLength: 2,
        delay: 300,
        select: function(event, ui) {
            //$('#sku').val(skus[ui.item.value]);
            OnFindNameUsing(ui.item.value)
        }
    });}

//  Функция создания коллекций Яндекс-объектов
function CollectionsInit() {
    //  Набор массивов, которые формируются для более гибкого отображения данных на странице.
    //  Являются параметрами глобальной переменной-объекта.

    Collections = new Object();
    Collections.All = new Array();
    Collections.Religion_1 = new Array();
    Collections.Religion_2 = new Array();
    Collections.Religion_3 = new Array();
    Collections.Religion_4 = new Array();
    Collections.Zoom_8 = new Array();
    Collections.Zoom_9 = new Array();
    Collections.Zoom_10 = new Array();
    Collections.Zoom_11 = new Array();
    Collections.Zoom_12 = new Array();
    Collections.Zoom_13 = new Array();
    Collections.Zoom_14 = new Array();
    Collections.Zoom_15 = new Array();
    Collections.Zoom_16 = new Array();
    Collections.Zoom_17 = new Array();
    Collections.Zoom_18 = new Array();
    Collections.Zoom_19 = new Array();
    Collections.FindName = new Array();
    Collections.Names = new Array();
    Collections.Export = new Array();
    //  Коллекция для отражения данных на карте.
    CollectionVisible = new ymaps.GeoObjectCollection({},
        {
            //  Параметр коллекции всех элементов, отображающий название в красной рамке
            preset: 'islands#redStretchyIcon'
        });
}