﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.RDF;
using ModelData.BusinessModel.MainEntities;
using ModelData.BusinessModel.UnitOfWork;

namespace ModelData.BusinessModel
{
    public class BusinessDataManager
    {
        #region singl

        private static BusinessDataManager dataManager;
        public static BusinessDataManager Get()
        {
            if (dataManager == null)
                dataManager = new BusinessDataManager();

            return dataManager;
        }
        public static void Destroy()
        {
            dataManager = null;
        }

        private BusinessDataManager()
        {
            Init();
        }

        #endregion

        #region Data

        private bool needUpdate;
        private List<Settlement> infoAboutSettlements;

        #endregion

        #region Private Methods

        private void Init()
        {
            needUpdate = true;
            infoAboutSettlements = new List<Settlement>();
        }        

        #endregion

        #region Public Methods

        public bool Update
        {
            get { return needUpdate; }
            set { if (value) needUpdate = true; }
        }

        public Context GetSettlements(int YearMin, int YearMax)
        {
            Context context = new Context();
            context.GetAllSettlements(YearMin.ToString(), YearMax.ToString());
            return context;
        }

        public Settlement GetInfoAboutSettlement(string URL)
        {
            Settlement settlement;
            if (!needUpdate /*&& infoAboutSettlements.Exists(x => x.URL == URL)*/)
            {
                settlement = infoAboutSettlements.Find(x => x.URL == URL);
                if (settlement != null)
                    return settlement;
            }
            else
                infoAboutSettlements = new List<Settlement>();

            settlement = new Context().LoadInfoAboutSettlement(URL);
            infoAboutSettlements.Add(settlement);

            return settlement;
        }


        //  запрос всех имён за данный период
        public string[] GetSettlementsNames(string subName)
        {
            return new string[1];
        }

        public (int min, int max) GetYears()
        {
            var query_result = RDFQuery.GetData(RDFQuery.QueryType.Years, new string[] { });
            string u = query_result[0]["min"].ToString().Split('^')[0];
            string k = query_result[0]["min"].ToString();
            return (
                    min: int.Parse(query_result[0]["min"].ToString().Split('^')[0]),
                    max: int.Parse(query_result[0]["max"].ToString().Split('^')[0])
                    );
        }       

        #endregion

    }
}
