﻿//  Функция обработчик движения слайдера
function SliderOnFinishMoving(data) {   
    CurrentMinYear = data.min;
    CurrentMaxYear = data.max;
    GetAllPoints(CurrentMinYear, CurrentMaxYear);
}

function OnFindNameUsing(name) {
    //  Добавить в коллекцию, чтобы гарантировать что данный объект появится на карте
    Collections.FindName = name;
    //  Найти метку в коллекции всех меток
    var placemark = Collections.AllGeoObjects.search('options.Name = "' + name + '"').get(0);
    //  Установить новый цвет
    placemark.options.set('preset', 'islands#greenStretchyIcon');
    //  Отцентрировать карту и приблизить
    Map.setCenter(placemark.geometry.getCoordinates(), 13);
    //  Через 5 секунд вернуть обратно прежний цвет
    setTimeout(changePlacemarkPreset, 5000, placemark, 'islands#redStretchyIcon');
}

function changePlacemarkPreset(placemark, preset) {
    placemark.options.set('preset', preset);
}

//  Заполнение массивов из исходного (response.data)
//  В соответствии с параметрами поселения
function FillDataArrays(fromData, isNeedSelect = false, isNeedPlaceCollection = false) {

    Collections.AllGeoObjects.removeFromMap(Map);

    Collections.All = new Array();
    Collections.AllGeoObjects = new ymaps.geoQuery();
    Collections.SettlementTypes = new Array();
    Collections.Regions = new Array();
    Collections.Names = new Array();
    Collections.FindName = '';

    console.log('Количество загруженных поселений ' + fromData.arraySettlements.length);
    
    Collections.Names = fromData.arrayNameSettlements;
    Collections.SettlementTypes = fromData.arrayNameTypes;
    Collections.Regions = fromData.arrayNameRegions;   
    AutoCompleteInit(Collections.Names);

    Collections.All = fromData.arraySettlements;
    LoadCollection(fromData.arraySettlements, isNeedSelect, isNeedPlaceCollection);
}

//  Функция заполнения Яндекс-коллекций Яндекс-объектами из JSON массива
function LoadCollection(fromData, isNeedSelect = false, isNeedPlaceCollection = false) {
    fromData.forEach(function (element) {
        Collections.AllGeoObjects = Collections.AllGeoObjects.add(CreateYandexPlacemark(element)); //  Добавление
    });
    if (isNeedSelect)
        SelectDataFromArrays(isNeedPlaceCollection);
}

//  Согласно текущим установленным фильтрам собрать нужный массив данных
function SelectDataFromArrays(isNeedPlaceCollection = false) {
    var ResultDataArray = new Array();   

    var CollectionVisible = Collections.AllGeoObjects.searchInside(Map).slice(0, Collections.VisibleCount).addToMap(Map);
    // Оставшиеся объекты будем удалять с карты.
    Collections.AllGeoObjects.remove(CollectionVisible).removeFromMap(Map).getLength();

    //for (var i = 0; i < Collections.All.length && i < Collections.VisibleCount; i++) {
    //    ResultDataArray.push(Collections.All[i]);
    //}

    //if (isNeedPlaceCollection)
    //    PlaceFromCollection(geo_query);
    return ResultDataArray;
}


//  Функция создания Яндекс-объекта из одного элемента JSON массива
function CreateYandexPlacemark(fromElement) {
    var coord = fromElement.Position.split(' ');
    var placemark = new ymaps.Placemark([coord[0], coord[1]],
        {
            iconContent: fromElement.Title,   //  Содержимое названия
            hintContent: fromElement.Position//  Содержимое подписи при наведении
        },
        {
            preset: 'islands#redStretchyIcon'
        }
    );

    //Добавить свойство - Имя поселения
    placemark.options.set('Name', fromElement.Title);
    placemark.options.set('URL', fromElement.URL);
    placemark.options.set('Population', fromElement.Population);
    placemark.options.set('Types', fromElement.Type);
    placemark.options.set('Regions', fromElement.Region);

    //  Переопределяем стадартный обработчик нажатия
    placemark.events.add('click', function (e) {
        e.preventDefault(); //  Запрещаем стандартный обработчик

        var targetURL = e.get('target').options.get('URL');

        //  Вызов запроса на получение данных о поселении
        GetInfoAboutSettlement(targetURL, PrintInfoAboutSettlement);
        //  Показать боковую панель
        if ($('#sidebar-left, #content').hasClass('active')) {
            //  Панель скрыта. Должна выехать
            $('#sidebar-left, #content').removeClass('active');
            $('.collapse.in').toggleClass('in');
            $('a[aria-expanded=true]').attr('aria-expanded', 'false');
        }
        else
            //  Панель есть. Выбор, нужно ли её скрывать
            if (targetURL == document.getElementById('settlement-url').innerHTML) {
                $('#sidebar-left, #content').addClass('active');
                $('.collapse.in').toggleClass('in');
                $('a[aria-expanded=true]').attr('aria-expanded', 'false');
            }


    });
    return placemark;
}


// функция динамической сортировки
function compareValues(key, order = 'asc') {
    return function (a, b) {
        if (!a.hasOwnProperty(key) || !b.hasOwnProperty(key)) {
            // свойства нет ни в одном из объектов
            return 0;
        }

        const varA = (typeof a[key] === 'string') ?
            a[key].toUpperCase() : a[key];
        const varB = (typeof b[key] === 'string') ?
            b[key].toUpperCase() : b[key];

        let comparison = 0;
        if (varA > varB) {
            comparison = 1;
        } else if (varA < varB) {
            comparison = -1;
        }
        return (
            (order == 'desc') ? (comparison * -1) : comparison
        );
    };
}   