﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools;

namespace ModelData.BusinessModel.BaseAndInterface
{

    /*!
	\brief Родительский класс, не несущий никакой смысловой нагрузки

	Данный класс имеет только одну простую цель: проиллюстрировать то,
	как Doxygen документирует наследование 
    */

    /// \class  BaseOntologyEntity
    ///
    /// \brief  A base ontology entity. - краткое описание
    /// полное описание
    /// \author Deniska
    /// \date   30.03.2019
    ///         
    ///         
    /// \authors	
    /// \version 
    /// \date 
    /// \bug 
    /// \warning
    /// \todo

    public abstract class BaseOntologyEntity : I_URLcs, I_MySerializable
    {
        [IndexAttrib(0)] public string URL { set; get; }
        [IndexAttrib(1)] public string Title { set; get; }
        public abstract Dictionary<string, string> Serialize();

        /// \fn protected string Concat(List<string> l)
        ///
        /// \brief  Concatenates the given l
        ///
        /// \author Deniska
        /// \date   30.03.2019
        ///
        /// \param  l   A List&lt;string&gt; to process.
        ///
        /// \returns    A string.
        ///  
        ///  
        /// \param [<направление>] <имя_параметра> {описание_параметра}
        /// Копирует содержимое из исходной области памяти в целевую область память
        /// \param[out] dest Целевая область памяти
        /// \param[in] src Исходная область памяти
        /// \param[in] n Количество байтов, которые необходимо скопировать
        /// \return {описание_возвращаемого_значения}
        /// \throw std::bad_alloc В случае возникновения ошибки при выделении памяти

        protected string Concat(List<string> l)
        {
            string r = "";
            if (l != null)
                foreach (string s in l)
                    if (s != null && s != "")
                        r += s;
            return r;
        }

        protected string Concat(Dictionary<string, string> l)
        {
            string r = "";
            if (l != null)
                foreach (var s in l)
                    if (s.Value != null && s.Value != "")
                        r += s.Key + " : " + s.Value + "\n";
            return r;
        }

        /*
         /// Набор возможных состояний объекта
         enum States {
         Disabled, ///< Указывает, что элемент недоступен для использования
         Undefined, ///< Указывает, что состояние элемента неопределенно
         Enabled, ///< Указывает, что элемент доступен для использования
                     }
         */

        /*
         
         \defgroup <идентификатор> (заголовок модуля)
         \defgroup maze_generation Генерация лабиринтов
         \brief Данный модуль, предназначен для генерации лабиринтов.
    
         На данный момент он поддерживает следующие алгоритмы генерации лабиринтов: Eller's algorithm, randomized Kruskal's algorithm, cellular automaton algorithm, randomized Prim's algorithm.
        
         .......

         \ingroup <идентификатор> (заголовок модуля) - это для добавления каждого блока в группу

         .......

         \addtogroup <идентификатор> [(заголовок модуля)]
         \addtogroup FooGroup 
         \{ @{

         Summon a goat
        
         \param name The name of the goat;
         \return The summoned goat;
        
         Goat summon_goat(const char* name);
        
        ...
        ...

         \} @}

         */

        /*! \defgroup main_module Главный модуль */

        /*! \defgroup second_module Вложенный модуль 
             \ingroup main_module
        */


        /*
         \brief Алгоритм Евклида
         \param a,b Два числа, чей наибольший делитель мы хотим найти

         Данная функция реализует алгоритм Евклида, при помощи которого
         находится наибольшее общее кратное у двух чисел.

         Код функции выглядит следующим образом:
         \code
         int gcd(int a, int b) {
                int r;
                while (b) {
                      r = a % b;
                      a = b;
                      b = r;
                }
                return r;
         }
         \endcode

        int gcd(int a, int b);
        */

        /*
         \callgraph
         \callergraph
         */

        /*! \file
        Компоновщик (англ. Composite pattern) — структурный шаблон проектирования, объединяющий объекты в древовидную структуру для представления иерархии от частного к целому. Компоновщик позволяет клиентам обращаться к отдельным объектам и к группам объектов одинаково. Ниже представлена иллюстрация данного шаблона при помощи UML:
        \startuml
            interface Component {
               +doThis()
            }
            class Composite {
               -elements
               +addElement()
               +doThis()
            }
            class Leaf {
               +doThis()
            }
            Component <|-- Leaf
            Component<|-- Composite 
            Composite  o-- Component 
        \enduml
        */
    }
}
