﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.BaseAndInterface;
using Tools;


namespace ModelData.BusinessModel.ExtraEntities
{
    public class Founder : BaseOntologyEntity
    {
        [IndexAttrib(2)]
        public string Name { set; get; }
        [IndexAttrib(3)]
        public string FounderRegion { set; get; }
        [IndexAttrib(4)]
        public string Nationality { set; get; }

        public override Dictionary<string, string> Serialize()
        {
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Название"] = this.Title ?? "",
                ["Имя"] = this.Name ?? "",
                ["Регион основателя"] = this.FounderRegion ?? "",
                ["Национальность"] = this.Nationality ?? ""
            };
        }
    }
}
