﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools;


namespace ModelData.BusinessModel.MainEntities
{
    public class MapPoint : BaseAndInterface.BaseOntologyEntity
    {
        [IndexAttrib(2)] public string Position { set; get; }
        [IndexAttrib(3)] public string Population { set; get; }
        [IndexAttrib(4)] public List<string> Type { set; get; }
        [IndexAttrib(5)] public List<string> Region { set; get; }

        public MapPoint()
        {
            Type = new List<string>();
            Region = new List<string>();
        }

        public override Dictionary<string, string> Serialize()
        {
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Название"] = this.Title ?? "",
                ["Координаты"] = this.Position ?? "",
                ["Количество населения"] = this.Population,
                ["Тип поселения"] = Concat(this.Type),
                ["В составе региона"] = Concat(this.Region)
            };
        }

    }
}
