﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.BaseAndInterface;
using Tools;

namespace ModelData.BusinessModel.ExtraEntities
{
    public class SettlementType:BaseOntologyEntity 
    {
        [IndexAttrib(2)] public string Description { set; get; }
        [IndexAttrib(3)] public List<string> AlternativeName { set; get; }
        public override Dictionary<string,string> Serialize()
        {
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Название"] = this.Title ?? "",
                ["Описание"] = this.Description ?? "",
                ["Другое название"] = Concat(this.AlternativeName)
            };
        }
    }
}
