﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.Tools;
using ModelData.BusinessModel.BaseAndInterface;
using ModelData.BusinessModel.ExtraEntities;

using Tools;

namespace ModelData.BusinessModel.MainEntities
{
    public class EditedSettlement : BaseOntologyEntity
    {
        #region Обязательные данные

        //  URL

        [IndexAttrib(2)] public Settlement before { set; get; }
        [IndexAttrib(3)] public InstantTime hasBeginning { set; get; }
        [IndexAttrib(4)] public string Source { set; get; }

        #endregion

        #region Необязательные данные

        //  Title
        
        [IndexAttrib(5)] public SettlementType Type { set; get; }
        [IndexAttrib(6)] public Region Region { set; get; }
        [IndexAttrib(7)] public int? PopulationAll { set; get; }
        [IndexAttrib(8)] public int? PopulationMales { set; get; }
        [IndexAttrib(9)] public int? PopulationFemales { set; get; }
        [IndexAttrib(10)] public List<string> AlternativeName { set; get; }
        [IndexAttrib(11)] public Dictionary<string, string> Others { set; get; }

        #endregion

        #region Конструктор

        protected EditedSettlement()
        {
            Init();
        }

        public EditedSettlement(string URL, Settlement before, InstantTime hasBeginning, string Source)
        {
            this.URL = URL;
            this.before = before;
            this.hasBeginning = hasBeginning;
            this.Source = Source;

            Init();
        }

        protected void Init()
        {
            AlternativeName = new List<string>();
            Others = new Dictionary<string, string>();
        }

        public override Dictionary<string, string> Serialize()
        {
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Соответствующий год"] = this.hasBeginning.ToString() ?? "",
                ["В составе региона"] = Concat(this.Region?.Serialize()) ?? "",
                ["Тип поселения"] = Concat(this.Type?.Serialize()) ?? "",
                ["Всего населения"] = PopulationAll?.ToString() ?? "",
                ["Мужского населения"] = PopulationMales?.ToString() ?? "",
                ["Женского населения"] = PopulationFemales?.ToString() ?? "",
                ["Другое название"] = Concat(this.AlternativeName) ?? ""
            };
        }

        #endregion
    }
}
