﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.Tools;
using ModelData.BusinessModel.ExtraEntities;
using ModelData.BusinessModel.BaseAndInterface;

using Tools;

namespace ModelData.BusinessModel.MainEntities
{
    public class Settlement : BaseOntologyEntity
    {
        #region Обязательные данные

        //  URL

        //  Title

        [IndexAttrib(2)] public Coordinate Coordinate { set; get; }

        #endregion

        #region Необязательные данные

        [IndexAttrib(3)] public InstantTime hasBeginning { set; get; }
        [IndexAttrib(4)] public Founder Founder { set; get; }
        [IndexAttrib(5)] public string Legend { set; get; }
        [IndexAttrib(6)] public Dictionary<string, string> Others { set; get; }

        #endregion

        #region Служебные данные

        [IndexAttrib(7)] public List<EditedSettlement> EditedSettlements { set; get; }

        #endregion

        #region Конструктор

        protected Settlement()
        {
            Init();
        }

        public Settlement(string URL, string Title, Coordinate Coordinate)
        {
            this.URL = URL;
            this.Title = Title;
            this.Coordinate = Coordinate;

            Init();
        }

        protected void Init()
        {
            Others = new Dictionary<string, string>();
            EditedSettlements = new List<EditedSettlement>();
        }

        public override Dictionary<string, string> Serialize()
        {
            List<string> edited = new List<string>();
            foreach (var edit in EditedSettlements)
                edited.Add(Concat(edit.Serialize()));
            
            return new Dictionary<string, string>()
            {
                ["URL"] = this.URL ?? "",
                ["Название"] = this.Title ?? "",
                ["Год основания"] = this.hasBeginning?.ToString() ?? "",
                ["Основатель"] = Concat(this.Founder?.Serialize()) ?? "",
                ["История основания"] = this.Legend ?? "",
                ["Дополнительно"] = Concat(edited) ?? ""
            };
        }

        #endregion       
    }
}
