﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ComponentModel;

namespace ModelData.BusinessModel.Tools
{
    public class Coordinate
    {
        [DisplayName("Ширина")]
        public double Lat { set; get; }

        [DisplayName("Долгота")]
        public double Long { set; get; }


        public Coordinate()
        {
            Lat = 0;
            Long = 0;
        }
        public Coordinate(VDS.RDF.INode long_, VDS.RDF.INode lat_)
        {
            this.Lat = double.Parse(long_.ToString().Split('^')[0].Replace('.', ','));
            this.Long = double.Parse(lat_.ToString().Split('^')[0].Replace('.', ','));
        }
        public Coordinate(double x, double y)
        {
            this.Lat = x;
            this.Long = y;
        }
        public Coordinate(Position origin)
        {
            Lat = origin.X;
            Long = origin.Y;
        }


        public static bool TryParse(string src, out Coordinate val)
        {
            val = new Coordinate();
            return true;
        }
        public override string ToString()
        {
            return Lat + " " + Long;
        }


    }
}