﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel;

namespace ModelData.WebModel
{
    public class WebDataManager
    {
        #region singl

        private static WebDataManager dataManager;
        public static WebDataManager Get()
        {
            if (dataManager == null)
                dataManager = new WebDataManager();

            return dataManager;
        }
        public static void Destroy()
        {
            dataManager = null;
        }

        private WebDataManager()
        {
            Init();
        }

        #endregion

        #region Data
        #endregion

        #region Methods

        public MapPoint[] GetMapPoints(int YearMin, int YearMax)
        {
            BusinessDataManager businessData = BusinessDataManager.Get();

            Settlement[] settlements = businessData.GetSettlements(YearMin, YearMax);
            List<MapPoint> mapPoints = new List<MapPoint>(settlements.Length);

            foreach (var elem in settlements)
                mapPoints.Add(new MapPoint()
                {
                    URL = elem.URL,
                    Name = elem.Name,
                    Position = elem.position,
                    Population = elem.Population
                });

            return mapPoints.ToArray();
        }

        public Settlement GetSettlement(string URL)
        {
            BusinessDataManager businessData = BusinessDataManager.Get();

            return businessData.GetInfoAboutSettlement(URL);
        }

        public string[] GetSettlementsNames(string subName)
        {
            BusinessDataManager businessData = BusinessDataManager.Get();

            return businessData.GetSettlementsNames(subName);
        }

        #region Tools

        private void Init(int Count = 5)
        {            
        }
        #endregion

        #endregion

    }
}
