﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools;

namespace ModelData.BusinessModel.BaseAndInterface
{
    /*!
        \defgroup Entities Сущности
        \brief Группа классов всех сущностей

        Включает в себя такие сущности: BaseOntologyEntity, 
        @{
     */

    /// \class  BaseOntologyEntity
    ///
    /// \brief  Базовый класс онтологической сущности.
    /// Данный класс описывает сущность, обладающую уникальным идентификатором (URL) и собственным названием (Title). 
    /// Данные параметры наследованы от интерфейса I_URL.
    /// \author Denis
    /// \date   30.03.2019

    public abstract class BaseOntologyEntity : I_URLcs, I_MySerializable
    {
        /// \property   public string URL
        ///
        /// \brief  Уникальный идентификатор сущности.
        /// Установлен атрибут IndexAttrib со значением 0, т.е. данное свойство будет выводится первым при записи в поток.
        /// \returns    The URL.

        [IndexAttrib(0)] public string URL { set; get; }



        /// \property   public string Title
        ///
        /// \brief  Наименование сущности.
        /// Установлен атрибут IndexAttrib со значением 1.
        /// \returns    The title.

        [IndexAttrib(1)] public string Title { set; get; }



        /// \fn public abstract Dictionary<string, string> Serialize();
        ///
        /// \brief  Метод, помещающий все необходимые сведения об объекте в Dictionary для последущей записи в поток.
        ///
        /// \author Denis
        /// \date   30.03.2019
        ///
        /// \returns    A Dictionary&lt;string,string&gt;

        public abstract Dictionary<string, string> Serialize();



        /// \fn protected string Concat(List<string> l)
        ///
        /// \brief  Объединяет непустые строки из списка в одну.
        ///
        /// \author Denis
        /// \date   30.03.2019
        ///
        /// \param  l   A List&lt;string&gt; to process.
        ///
        /// \returns    A string.

        protected string Concat(List<string> l)
        {
            string r = "";
            if (l != null)
                foreach (string s in l)
                    if (s != null && s != "")
                        r += s;
            return r;
        }



        /// \fn protected string Concat(Dictionary<string, string> l)
        ///
        /// \brief  Объединяет все непустые (Value) элементы из Dictionary в строку
        ///
        /// \author Denis
        /// \date   30.03.2019
        ///
        /// \param  l   A Dictionary&lt;string,string&gt; to process.
        ///
        /// \returns    A string.

        protected string Concat(Dictionary<string, string> l)
        {
            string r = "";
            if (l != null)
                foreach (var s in l)
                    if (s.Value != null && s.Value != "")
                        r += s.Key + " : " + s.Value + "\n";
            return r;
        }       
    }
    /// @}
}
